/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.DefaultConfigManager;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.TypeMapping;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.ConfigManager;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServiceManager {
    protected String configFilename = "soap.xml";
    protected DeploymentDescriptor smsdd;
    protected ConfigManager configMgr = null;
    protected ServletContext context = null;
    protected DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilder();

    public ServiceManager(ServletContext servletContext, String string) {
        this.context = servletContext;
        if (string != null && !string.equals("")) {
            this.configFilename = string;
        }
        this.readConfigFile();
        this.smsdd = new DeploymentDescriptor();
        this.smsdd.setID("urn:xml-soap-service-management-service");
        String[] stringArray = new String[]{"deploy", "undeploy", "list", "query"};
        this.smsdd.setMethods(stringArray);
        this.smsdd.setScope(2);
        this.smsdd.setProviderType((byte)0);
        this.smsdd.setProviderClass("org.apache.soap.server.ServiceManager");
        this.smsdd.setIsStatic(false);
        this.smsdd.setMappings(new TypeMapping[]{new TypeMapping("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://xml.apache.org/xml-soap", "DeploymentDescriptor"), "org.apache.soap.server.DeploymentDescriptor", "org.apache.soap.encoding.soapenc.BeanSerializer", "org.apache.soap.encoding.soapenc.BeanSerializer"), new TypeMapping("http://schemas.xmlsoap.org/soap/encoding/", new QName("http://xml.apache.org/xml-soap", "TypeMapping"), "org.apache.soap.server.TypeMapping", "org.apache.soap.server.TypeMappingSerializer", "org.apache.soap.server.TypeMappingSerializer")});
    }

    public void deploy(DeploymentDescriptor deploymentDescriptor) throws SOAPException {
        String string = deploymentDescriptor.getID();
        if (string.equals("urn:xml-soap-service-management-service")) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "service management service 'urn:xml-soap-service-management-service' cannot be user deployed");
        }
        this.configMgr.deploy(deploymentDescriptor);
    }

    public String[] list() throws SOAPException {
        return this.configMgr.list();
    }

    public DeploymentDescriptor query(String string) throws SOAPException {
        if (string == null) {
            return null;
        }
        if (string.equals("urn:xml-soap-service-management-service")) {
            return this.smsdd;
        }
        DeploymentDescriptor deploymentDescriptor = this.configMgr.query(string);
        if (deploymentDescriptor != null) {
            return deploymentDescriptor;
        }
        throw new SOAPException(Constants.FAULT_CODE_SERVER, "service '" + string + "' unknown");
    }

    private void readConfigFile() {
        block13: {
            FileReader fileReader = null;
            Document document = null;
            Element element = null;
            NodeList nodeList = null;
            Hashtable<String, String> hashtable = null;
            try {
                File file = ServerHTTPUtils.getFileFromNameAndContext(this.configFilename, this.context);
                fileReader = new FileReader(file);
                document = this.xdb.parse(new InputSource(fileReader));
                element = document.getDocumentElement();
                if (!"soapServer".equals(element.getTagName())) {
                    throw new Exception("Root element must be 'soapServer'");
                }
                nodeList = element.getChildNodes();
                int n = 0;
                while (nodeList != null && n < nodeList.getLength()) {
                    String string = null;
                    Node node = nodeList.item(n);
                    if (node.getNodeType() == 1 && (string = (element = (Element)node).getTagName()).equals("configManager")) {
                        String string2 = element.getAttribute("value");
                        ClassLoader classLoader = null;
                        Class<?> clazz = null;
                        classLoader = ServerHTTPUtils.getServletClassLoaderFromContext(this.context);
                        clazz = classLoader == null ? Class.forName(string2) : Class.forName(string2, true, classLoader);
                        this.configMgr = (ConfigManager)clazz.newInstance();
                        if (!(this.configMgr instanceof ConfigManager)) {
                            throw new Exception("Class " + string2 + " isn't a " + "ConfigManager");
                        }
                        this.configMgr.setContext(this.context);
                        NodeList nodeList2 = element.getElementsByTagName("option");
                        int n2 = 0;
                        while (nodeList2 != null && n2 < nodeList2.getLength()) {
                            element = (Element)nodeList2.item(n2);
                            string = element.getAttribute("name");
                            String string3 = element.getAttribute("value");
                            if (hashtable == null) {
                                hashtable = new Hashtable<String, String>();
                            }
                            if (string != null && string3 != null) {
                                hashtable.put(string, string3);
                            }
                            ++n2;
                        }
                        if (hashtable != null) {
                            this.configMgr.setOptions(hashtable);
                        }
                    }
                    ++n;
                }
                fileReader.close();
            }
            catch (Throwable throwable) {
                if (fileReader == null) break block13;
                System.err.println("Error processing configuration file (" + this.configFilename + ")");
                System.err.println("Error was: " + throwable);
                System.err.println("Using DefaultConfigManager");
            }
        }
        if (this.configMgr == null) {
            this.configMgr = new DefaultConfigManager();
            this.configMgr.setContext(this.context);
        }
        try {
            this.configMgr.init();
        }
        catch (SOAPException sOAPException) {
            sOAPException.printStackTrace();
        }
    }

    public void setConfigFilename(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.configFilename = string;
        this.readConfigFile();
    }

    public DeploymentDescriptor undeploy(String string) throws SOAPException {
        return this.configMgr.undeploy(string);
    }
}

