/***********************************************************************//**
	@file
	$Revision: 80 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:08:47 +0900#$
***************************************************************************/
#ifndef __OPENMJ_SERVER_LOBBY_H__
#define __OPENMJ_SERVER_LOBBY_H__

#include <boost/thread.hpp>
#include "common/Version.h"
#include "Receiver.h"

namespace openmj {
class Socket;
namespace server {
class Game;
/***********************************************************************//**
	ロビー
***************************************************************************/
class Lobby : public Receiver {
  public:
    static const Version UMP_VERSION;

  private:
    Socket socket_;
    Game* game_;
    boost::mutex mutex_;

  public:
    Lobby();
    ~Lobby();

    void exec();

  protected:
    virtual void recv(Player* player, const Command& command);

  private:
    void newGame();
};
/***********************************************************************//**
	$Id: Lobby.h 80 2009-03-28 13:08:47Z yatsuhashi $
***************************************************************************/
}	/* namespace server */
}	/* namespace openmj */
#endif	/* __OPENMJ_SERVER_LOBBY_H__ */
