/***********************************************************************//**
	@file
	$Revision: 80 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:08:47 +0900#$
***************************************************************************/
#ifndef __OPENMJ_SERVER_GAME_H__
#define __OPENMJ_SERVER_GAME_H__

#include <vector>
#include <boost/thread.hpp>
#include "Receiver.h"

namespace openmj {
namespace server {
class Player;
/***********************************************************************//**
	
***************************************************************************/
class Game : public Receiver {
  private:
    typedef std::vector<Player*> PlayerVector;

  private:
    const int playerMax_;
    PlayerVector playerList_;
    boost::thread* thread_;
    boost::mutex mutex_;

  public:
    Game(int playerMax = 4);
    ~Game();

    bool appendPlayer(Player* player);
    void start();

  protected:
    virtual void recv(Player* player, const Command& command);

  private:
    static void Exec(Game* game);
    void exec();

    void sendAll(const char* command);
};
/***********************************************************************//**
	$Id: Game.h 80 2009-03-28 13:08:47Z yatsuhashi $
***************************************************************************/
}	/* namespace server */
}	/* namespace openmj */
#endif	/* __OPENMJ_SERVER_GAME_H__ */
