/***********************************************************************//**
	@file
	$Revision: 82 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:46:44 +0900#$
***************************************************************************/
#include "Dialog.h"
#include "Connection.h"

namespace openmj {
namespace gui {
namespace preference {
/***********************************************************************//**
	コンストラクタ.
***************************************************************************/
Dialog::Dialog(wxWindow* parent)
    : super(parent), 
      connectionCounter(0)
{
    appendConnection();
}
/***********************************************************************//**
	デストラクタ.
***************************************************************************/
Dialog::~Dialog() {}
/***********************************************************************//**
	接続先を追加.
***************************************************************************/
void Dialog::appendConnection() {
    wxString name = wxString::Format(wxT("接続%d"), ++connectionCounter);
    Connection* connection = new Connection(noteBook, name);
    noteBook->AddPage(connection, name);
}
void Dialog::onAppendConnection(wxCommandEvent& event) {
    appendConnection();
    noteBook->ChangeSelection(noteBook->GetPageCount() - 1);
}
/***********************************************************************//**
	接続先を削除.
***************************************************************************/
void Dialog::onRemoveConnection(wxCommandEvent& event) {
    size_t page = noteBook->GetSelection();
    if(page >= 0) {
        noteBook->RemovePage(page);
    }
}
/***********************************************************************//**
	$Id: Dialog.cpp 82 2009-03-28 13:46:44Z yatsuhashi $
***************************************************************************/
}	/* namespace preference */
}	/* namespace gui */
}	/* namespace openmj */
