/***********************************************************************//**
	@file
	$Revision: 82 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:46:44 +0900#$
***************************************************************************/
#include "DrawPacketHai.h"
#include "Resource.h"

namespace openmj {
namespace gui {

const DrawPacketHai::ShapeTable DrawPacketHai::shapeTable[12] = {
    { 0, 24, 0, -44, 0, 12 }, 
    { 24, 20, -20, -44, 0, 0 }, 
    { 48, 24, -32, -12, 0, 0 }, 
    { 72, 20, 0, -20, 0, 0 }, 

    { 96, 24, 0, -44, 0, 0, 0, 0 }, 
    { 120, 32, -32, -44, 0, 8, 0, 16 }, 
    { 96, 24, -24, -12, 0, 0, 16, 24 }, 
    { 120, 32, 0, -20, 0, 8, 24, 0 }, 

    { 120, 32, 0, -44, 0, 8 }, 
    { 96, 24, -24, -44, 0, 0 }, 
    { 120, 32, -32, -20, 0, 8 }, 
    { 96, 24, 0, -12, 0, 0 }, 
};
const Color DrawPacketHai::nakiColor(0x60, 0x60, 0x60);
const Color DrawPacketHai::disableColor(0x70, 0x70, 0x70);
const Color DrawPacketHai::lastColor(0x80, 0x60, 0x60);
/***********************************************************************//**
	コンストラクタ.
***************************************************************************/
DrawPacketHai::DrawPacketHai(const wxPoint& pos, const mahjong::Hai* hai, 
                             int rotate, int flag)
    : super(pos, ((flag & FLAG_UPPER) ? 1 : 0)), 
      hai_(hai), 
      rotate_(rotate), 
      flag_(flag)
{
    shape_ = rotate;
    if(flag & (FLAG_OPEN | FLAG_CLOSE)) {
        shape_ += 4;
        if(flag & FLAG_BEND) {
            shape_ += 4;
            rotate_++;
        }
    }
}
/***********************************************************************//**
	描画.
***************************************************************************/
void DrawPacketHai::draw(wxDC& dc) const {
    const Resource* resource = Resource::getInstance();
    const ShapeTable& table = shapeTable[shape_];
    wxRect rect(table.x + ((flag_ & FLAG_CLOSE) ? 56 : 0), 
                Resource::HAI_HEIGHT * 8, table.w, 48);
    wxImage image = resource->getImage(rect);
    if(flag_ & FLAG_NAKI) {
        image = nakiColor.applyImage(image);
    }
    else if(flag_ & FLAG_DISABLE) {
        image = disableColor.applyImage(image);
    }
    else if(flag_ & FLAG_LAST) {
        image = lastColor.applyImage(image);
    }
    wxPoint pos = getPos();
    pos.x += table.offsetX;
    pos.y += table.offsetY;
    dc.DrawBitmap(wxBitmap(image), pos, true);
    pos.x += table.faceX;
    pos.y += table.faceY;
    if(hai_ && !(flag_ & FLAG_CLOSE)) {
        wxImage image = resource->getHaiImage(hai_, rotate_);
        dc.DrawBitmap(wxBitmap(image), pos, true);
    }
    if(flag_ & FLAG_TSUMOGIRI) {
        wxImage image = resource->getTsumogiriImage(rotate_);
        dc.DrawBitmap(wxBitmap(image), 
                      pos.x + table.tsumogiriX, 
                      pos.y + table.tsumogiriY, true);
    }
}
/***********************************************************************//**
	$Id: DrawPacketHai.cpp 82 2009-03-28 13:46:44Z yatsuhashi $
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
