/***********************************************************************//**
	@file
	$Revision: 82 $
	$Author: yatsuhashi $
	$Date:: 2009-03-28 22:46:44 +0900#$
***************************************************************************/
#include "ClientThread.h"
#include "Client.h"

namespace openmj {
namespace gui {
/***********************************************************************//**
	コンストラクタ.
***************************************************************************/
ClientThread::ClientThread(Client& client)
    : client(client)
{}
/***********************************************************************//**
	デストラクタ.
***************************************************************************/
ClientThread::~ClientThread() {}
/***********************************************************************//**
	
***************************************************************************/
void* ClientThread::Entry() {
    client.exec();
    return 0;
}
/***********************************************************************//**
	
***************************************************************************/
ClientThread* ClientThread::Start(Client& client) {
    ClientThread* thread = new ClientThread(client);
    if(thread->Create() != wxTHREAD_NO_ERROR) {
        fprintf(stderr, "Can't create thread");
        delete thread;
        return 0;
    }
    thread->Run();
    return thread;
}
/***********************************************************************//**
	$Id: ClientThread.cpp 82 2009-03-28 13:46:44Z yatsuhashi $
***************************************************************************/
}	/* namespace gui */
}	/* namespace openmj */
