/***********************************************************************//**
	@file
	$Revision: 83 $
	$Author: yatsuhashi $
	$Date:: 2009-03-29 01:13:14 +0900#$
***************************************************************************/
#ifndef __OPENMJ_COMMAND_H__
#define __OPENMJ_COMMAND_H__

#include <string>
#include <vector>

namespace openmj {
/***********************************************************************//**
	コマンド
***************************************************************************/
class Command {
  public:
    typedef std::vector<std::string> Args;

  public:
    enum {
        CMD_NULL, 
        CMD_HELLO, 
        CMD_ERROR, 
        CMD_GAMESTART, 
        CMD_GAMEEND, 
        CMD_KYOKUSTART, 
        CMD_READY_Q, 
        CMD_POINT, 
        CMD_DICE, 
        CMD_HAIPAI, 
        CMD_OPEN, 
        CMD_DORA, 
        CMD_TSUMO, 
        CMD_SUTEHAI_Q, 
        CMD_SUTEHAI, 
        CMD_NAKU_Q, 
        CMD_SAY, 
        CMD_AGARI, 
        CMD_RYUKYOKU, 
        CMD_TENPAI_Q, 

        CMD_RICHI, 
        CMD_RON, 
        CMD_YES, 
        CMD_NO, 
        CMD_OK, 

        CMD_MAX
    };

  private:
    unsigned int serial_;
    int command_;
    Args args_;

    static const char* TABLE[];

  public:
    Command();
    Command(unsigned int serial, int command = CMD_NULL);

    unsigned int getSerial() const;
    int getCommand() const;
    int getArgNum() const;
    const std::string& getArg(int index) const;
    const Args& getArgs() const;

    void setCommand(int command);
    void append(const char* arg);

    bool parse(const char* command);

    std::string toString() const;

    static std::string Encode(const char* src);
    static std::string Decode(const char* src, int len = 0);
};
/***********************************************************************//**
	$Id: Command.h 83 2009-03-28 16:13:14Z yatsuhashi $
***************************************************************************/
}	/* namespace openmj */
#endif	/* __OPENMJ_COMMAND_H__ */
