/***********************************************************************//**
	@file
	$Revision: 77 $
	$Author: yatsuhashi $
	$Date:: 2009-03-26 02:38:16 +0900#$
***************************************************************************/
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>
#include "libmahjong/Hand.h"
#include "HandTest.h"

namespace mahjong {
/***********************************************************************//**
	
***************************************************************************/
void HandTest::testOpen() {
    Hand hand;
    hand.setHaipai(HaiArray("1m1m1m7m8m9m2s2s2s7s8s2z2z"));
    fprintf(stderr, hand.toString().c_str());
    hand.open("<6s7s8s>", Hai::Get("6s"));
    //hand.open("<6s7s8s>", 0);
    //hand.naki(Hai::Get("6s"), HaiArray("7s8s"));
    //fprintf(stderr, hand.toString().c_str());
    CPPUNIT_ASSERT_EQUAL(hand.toString(), 
                         std::string("1m1m1m7m8m9m2s2s2s2z2z<6s7s8s>"));
}
/***********************************************************************//**
	
***************************************************************************/
void HandTest::testCanRichi() {
    Hand hand;
    hand.setHaipai(HaiArray("1m1m1m2m3m3m2s2s2s7s8s9s2z2z"));
    HaiArray hais = hand.canRichi();
    CPPUNIT_ASSERT_EQUAL(hais.toString(), 
                         std::string("1m2m3m"));
}
/***********************************************************************//**
	$Id: HandTest.cpp 77 2009-03-25 17:38:16Z yatsuhashi $
***************************************************************************/
}	/* namespace mahjong */
