/***********************************************************************//**
	@file
	$Revision$
	$Author$
	$Date::                           $
***************************************************************************/
#include "libmahjong.h"

namespace mahjong {
/***********************************************************************//**
	コンストラクタ.
***************************************************************************/
Yama::Yama() {
    for(int color = Hai::COLOR_MANZU; color <= Hai::COLOR_SOUZU; color++) {
        for(int number = 1; number <= 9; number++) {
            const Hai* hai = Hai::Get(color, number);
            for(int i = 0; i < 4; i++) {
                array_.append(hai);
            }
        }
    }
    for(int number = 1; number <= 7; number++) {
        const Hai* hai = Hai::Get(Hai::COLOR_ZIHAI, number);
        for(int i = 0; i < 4; i++) {
            array_.append(hai);
        }
    }
    shuffle();
}
/***********************************************************************//**
	洗牌.
***************************************************************************/
void Yama::shuffle() {
    array_.shuffle();
    getPt_ = 0;
    restNum_ = array_.getSize();
}
/***********************************************************************//**
	自摸る.
***************************************************************************/
const Hai* Yama::tsumo() {
    restNum_--;
    return getHai();
}
/***********************************************************************//**
	ドラ表示牌をめくる.
***************************************************************************/
const Hai* Yama::dora() {
    return getHai();
}
/***********************************************************************//**
	配牌を取る.
***************************************************************************/
HaiArray Yama::getHaipai() {
    HaiArray haipai;
    for(int i = 0; i < 13; i++) {
        haipai.append(tsumo());
    }
    return haipai;
}
/***********************************************************************//**
	残り枚数を返す.
***************************************************************************/
int Yama::getRest() const {
    return restNum_;
}
/***********************************************************************//**
	牌を1枚取り出す.
***************************************************************************/
const Hai* Yama::getHai() {
    return array_[getPt_++];
}
/***********************************************************************//**
	$Id$
***************************************************************************/
}	/* namespace mahjong */
