##
#	$Id: taku.rb 69 2009-03-09 18:29:47Z yatsuhashi $
#
module OpenMjServer
  class Taku
    include Enumerable
    extend Forwardable

    #
    def initialize(players = [])
      @players = players.dup
    end

    #
    def_delegators(:@players, :<<, :[], :index, :size)

    #
    def dup
      self.class.new(@players)
    end

    #
    def max?
      @players.size == $config[:player_max]
    end

    #
    def each(&proc)
      @players.dup.each { |player|
        proc.call(player)
      }
    end

    # 卓にいる全部のプレイヤーにコマンドを送る
    def send(*args)
      @players.each { |player|
        player.send(*args)
      }
    end

    # 特定のプレイヤーを除いてコマンドを送る
    def except_send(except, *args)
      @players.each { |player|
        if player != except
          player.send(*args)
        end
      }
    end

    #
    def close
      @players.each { |player|
        player.close
      }
    end

    # 場決め
    def bagime
      @players.sort_by { rand }
      @players.each_with_index { |player, i|
        player.set_seki((?A + i).chr)
      }
      @players
    end

    # 点数
    def points
      @players.sort! { |a, b|
        [ -a.point, a.seki ] <=> [ -b.point, b.seki ]
      }
      top = 0
      @players[1 .. -1].each_with_index { |player, i|
        point = (player.point - $config[:genten] + $config[:uma][i] + 400) / 1000
        player.point = point
        top -= point
      }
      @players[0].point = top
      @players.sort!
      @players.collect { |player| player.point }
    end

    #
    def sort!
      @players.sort!
    end

    #
    def rotate
      player = @players.shift
      @players << player
    end
  end
end
