##
#	$Id: player.rb 69 2009-03-09 18:29:47Z yatsuhashi $
#
module OpenMjServer
  class Player
    include Comparable
    extend Forwardable

    #
    def initialize(socket)
      @seki = nil
      @socket = OpenMj::UMPSocket.new(socket)
      @session_id = 0
      @option = Hash.new
      @point = $config[:genten]
      @hand = nil
    end
    attr_reader :seki
    attr_accessor :point

    #
    def_delegators(:@hand, 
                   :push, :pop, 
                   :tenpai?, 
                   :tsumo, 
                   :richi, :richi?, :can_richi?, 
                   :ankan, 
                   :count_dora, 
                   :oya?, 
                   :get_reaction, 
                   :set_haitei, 
                   :naki)

    #
    def set_seki(seki)
      if @seki
        raise(Error, 'duplicate seki')
      end
      @seki = seki
    end

    #
    def name
      @option[:name] || 'noname'
    end

    #
    def hand
      @hand.to_s
    end

    # 配牌
    def haipai(hais, bakaze, zikaze)
      @hand = Mahjong::Hand.new(hais)
      @hand.set_bakaze(bakaze)
      @hand.set_zikaze(zikaze)
    end

    # 捨て牌
    def sutehai(_hai, is_tsumogiri)
      if richi?
        hai = @hand[-1]
        is_tsumogiri = true
      else
        unless hai = @hand.have?(_hai)
          hai = @hand[-1]
        end
      end
      if is_tsumogiri
        if hai != @hand[-1]
          is_tsumogiri = false
        end
      else
        if !@hand.can_tedashi?(hai)
          is_tsumogiri = true
        end
      end
      @hand.sutehai(hai)
      return hai, is_tsumogiri
    end

    #
    def choice_sutehai
      @hand[-1]
    end

    #
    def get_agari(is_ron)
      @hand.get_agari(@hand[-1], is_ron)
    end

    #
    def send(*args)
      @session_id += 1
      args.unshift(@session_id)
      @socket.send(*args)
      self
    end

    #
    def recv
      while args = @socket.recv
        if args.shift.to_i == @session_id
          return args
        end
      end
      []
    end

    #
    def hello
      args = send('hello', "ump=#{UMP_VERSION}").recv
      if args.shift == 'hello'
         args.each { |arg|
          if match = /^(\w+)=(.+)$/.match(arg)
            @option[match[1].downcase.to_sym] = match[2]
          else
            @option[arg.downcase.to_sym] = true
          end
        }
        if @option[:ump] and
            OpenMj::Version.new(@option[:ump]) >= UMP_VERSION
          return self
        end
      end
      close
      nil
    end

    #
    def close
      @socket.close
    end

    #
    def to_s
      @seki
    end

    #
    def <=>(other)
      @seki <=> other.seki
    end
  end
end
