##
#	$Id: main.rb 69 2009-03-09 18:29:47Z yatsuhashi $
#
require 'yaml'
require 'uri'
require 'forwardable'
require 'thwait'
require 'mahjong.rb'
require 'common/version.rb'
require 'common/umpsocket.rb'
require 'server/player.rb'
require 'server/game.rb'
require 'server/kyoku.rb'
require 'server/taku.rb'
require 'client/ai/base.rb'

module OpenMjServer
  UMP_VERSION	= OpenMj::Version.new('0.1')
  PORT		= 1326

  class Error < StandardError; end

  #
  def self.start(config_file, port = PORT)
    $config = YAML.load(File.read(config_file).tr("\t", " "))
    server = TCPServer.open(PORT)
    loop {
      game = Game.new
      $config[:ai].times {
        Thread.start {
          Ai::Base.new('localhost', PORT).start
        }
      }
      while !game.ready?
        game.add_player(server.accept)
        puts('accept')
      end
      game.start
    }
  end
end

OpenMjServer.start(ARGV[0] || 
                   File.expand_path('config-default.yaml', 
                                    File.dirname($0)))
