##
#	$Id: game.rb 69 2009-03-09 18:29:47Z yatsuhashi $
#
module OpenMjServer
  class Game
    #
    def initialize
      @yama = Mahjong::Yama.new
      @taku = Taku.new
      @bakaze = Mahjong::Hai['1z']
      @tsumi = 0
      @kyotaku = 0
      @log = Array.new

      $config[:akahai].each { |hai|
        @yama.delete_one(Mahjong::Hai[hai.downcase])
        hai = Mahjong::Hai[hai.upcase]
        @yama << hai
      }
    end
    attr_reader :yama, :taku, :bakaze, :tsumi
    attr_accessor :kyotaku

    #
    def add_player(socket)
      player = Player.new(socket).hello
      if player
        @taku << player
      end
    end

    #
    def ready?
      @taku.max?
    end

    #
    def start
      @taku.bagime
      names = @taku.collect { |player| player.name }
      @taku.each { |player|
        player.send('gamestart', player, *names)
      }
      while @bakaze <= Mahjong::Hai[$config[:last_bakaze]]
        @yama.shuffle
        @log << Kyoku.new(self)
        if check_tobi
          break
        end
      end
      @taku.send('gameend', @taku.points)
      @taku.close
    end

    # 連荘
    def renchan
      @tsumi += 1
    end

    # 次
    def next(tsumi = false)
      @taku.rotate
      if @taku[0].seki == 'A'
        @bakaze = @bakaze.succ
      end
      if tsumi
        @tsumi += 1
      else
        @tsumi = 0
      end
    end

    private

    # ぶっ飛びチェック
    def check_tobi
      if $config[:rule_tobi]
        @taku.each { |player|
          if player.point < 0
            return true
          end
        }
      end
      false
    end
  end
end
