##
#	$Id: mahjong.rb 21 2008-11-16 18:27:54Z yatsuhashi $
#
require 'uri'
require 'mahjong/hai'
require 'mahjong/haiarray'
require 'mahjong/yama'
require 'mahjong/hand'
require 'mahjong/mentsu'
require 'mahjong/agari'
require 'mahjong/mentsutable'

module Mahjong
  class Error < StandardError; end

  REACTION	= [ :ron, :kan, :pon, :chi ]

  # 端数を切り上げる
  def self.round_up(val, base)
    (val + base - 1) / base * base
  end
end
