##
#	$Id$
#
module WxUI
  #
  class Hai
    include Singleton

    RESOURCE	= Wx::Image.new("#{TOPDIR}/resource/mjhai.png")
    WIDTH	= RESOURCE.get_width / 9
    HEIGHT	= RESOURCE.get_height / 4

    def initialize
      @bitmap = Hash.new
      rect = Wx::Rect.new(0, 0, WIDTH, HEIGHT)
      Mahjong::Hai::COLORS.each { |color|
        rect.x = 0
        (1 .. 9).each { |num|
          image = RESOURCE.get_sub_image(rect)
          4.times { |i|
            @bitmap["#{num}#{color}#{i}"] = image.convert_to_bitmap
            image = image.rotate90(false)
          }
          rect.x += WIDTH
        }
        rect.y += HEIGHT
      }
    end

    #
    def draw(dc, x, y, hai, direction)
      if hai
        dc.draw_bitmap(@bitmap["8z#{direction}"], x, y, true)
        dc.draw_bitmap(@bitmap["#{hai}#{direction}".downcase], x, y, true)
      else
        dc.draw_bitmap(@bitmap["9z#{direction}"], x, y, true)
      end
    end

    #
    def self.draw(dc, x, y, hai, direction = 0)
      instance.draw(dc, x, y, hai, direction)
    end
  end
end
