##
#	$Id: mainwindow.rb 10 2008-10-08 19:26:42Z yatsuhashi $
#
module GtkUI
  UMP_VERSION	= '0.1'

  class MainWindow < Gtk::Window
    include Singleton

    PLAYER_MAX = 4
    MENU_ITEMS = 
      [ [ '/ゲーム' ], 
        [ '/ゲーム/スタート', Gtk::ItemFactory::ITEM, nil, nil, 
          Proc.new { self.instance.start_game } ], 
        [ '/ゲーム/終了', Gtk::ItemFactory::ITEM, nil, nil, 
          Proc.new { self.instance.quit } ] ]

    BUTTON_MAX = 5
    BUTTONS = {
      :CHI	=> 'チー', 
      :PON	=> 'ポン', 
      :KAN	=> 'カン', 
      :RON	=> 'ロン', 
      :TSUMO	=> 'ツモ', 
      :RICHI	=> 'リーチ', 
      :OK	=> 'OK', 
      :PASS	=> 'パス', 
      :NOTEN	=> 'ノーテン', 
      :TENPAI	=> 'テンパイ', 
      :CONNECT	=> '接続', 
      :RUN_AI	=> 'AI起動'
    }

    #
    def initialize
      super('OpenMj')
      signal_connect('destroy') { quit }

      vbox = Gtk::VBox.new

      items = Gtk::ItemFactory.new(Gtk::ItemFactory::TYPE_MENU_BAR, 
                                   '<main>', nil)
      items.create_items(MENU_ITEMS)
      menubar = items.get_widget('<main>')
      vbox.pack_start(menubar, false)

      hbox = Gtk::HButtonBox.new
      [ :CONNECT, :RUN_AI ].each { |id|
        button = Gtk::Button.new(BUTTONS[id])
        button.signal_connect('clicked') {
          case id
          when :CONNECT
            start_game
          when :RUN_AI
            Thread.start {
              Ai::Base.new('localhost', 1326).start
            }
          end
        }
        hbox.add(button)
      }
      vbox.pack_start(hbox, false)

      hbox = Gtk::HBox.new
      @info = Gtk::Label.new
      @info.set_xalign(0)
      hbox.pack_start(Gtk::Frame.new.add(@info))

      @wanpai = Taku.new(Hai.width * 10, Hai.height)
      hbox.pack_start(@wanpai, false)

      vbox.pack_start(hbox, false)

      @player = Array.new
      PLAYER_MAX.times {
        player = Player.new
        vbox.pack_start(player, false)
        @player << player
      }
      @myself = nil
      @player_num = 0

      hbox = Gtk::HButtonBox.new
      hbox.layout_style = Gtk::ButtonBox::SPREAD
      @buttons = Array.new
      BUTTON_MAX.times { |i|
        button = Gtk::Button.new('-')
        button.signal_connect('clicked') { |widget|
          clicked_button(@buttons[i][1])
        }
        hbox.add(button)
        @buttons << [ button, nil ]
      }
      vbox.pack_start(hbox, false)
      @mode = nil

      @console = Console.new
      vbox.pack_start(@console, true)

      add(vbox)

      @client = nil
    end

    #
    def start
      show_all
      Gtk.main
    end

    #
    def quit
      Gtk.main_quit
    end

    #
    def start_game
      begin
        @client = OpenMj::Client.new
        Thread.start {
          @client.start { |command, args|
            @console.puts("#{command} #{args.join(' ')}")
            @mode = nil
            @sutehai = nil
            case command
            when 'hello'
              @client.send('hello', "ump=#{UMP_VERSION}")
            when 'gamestart'
              @myself = args.shift[0]
              @player_num = args.size
              args.each_with_index { |name, i|
                get_player((?A + i).chr).set_name(name)
              }
            when 'kyokustart'
              show_info(args)
              @wanpai.clear.flush
            when 'point'
              if /^=(\d+)$/.match(args[1])
                get_player(args[0]).set_point($1.to_i)
              end
            when 'dora'
              puts(args[0])
              hai = Hai[args[0]]
              @wanpai.draw_hai(hai)
              @wanpai.flush
            when 'haipai'
              get_player(args[0]).set_tehai(args[1])
            when 'tsumo'
              get_player(args[0]).tsumo(args[2])
            when 'sutehai?'
              @mode = :SUTEHAI
              set_button(nil, nil, :KAN, :RICHI, :TSUMO)
            when 'sutehai'
              get_player(args[0]).sutehai(args[1])
            when 'naku?'
              naki(Mahjong::Hai[args.shift], args)
            when 'tenpai?'
              set_button(nil, nil, nil, :NOTEN, :TENPAI)
            when 'open'
              get_player(args[0]).open(args[1], args[2])
            when 'ready?'
              set_button(nil, nil, nil, nil, :OK)
            end
          }
        }
      rescue Errno::ECONNREFUSED
        @client = nil
      end
    end

    # 牌を選んだ
    def click_hai(hai, is_tsumogiri)
      if @mode == :KAN
        cmd =  [ 'ankan', hai.to_s ]
      else
        if @mode == :RICHI
          cmd = [ 'richi' ]
        elsif @mode == :SUTEHAI
          cmd = [ 'sutehai' ]
        else
          return
        end
        cmd << hai.to_s
        if is_tsumogiri
          cmd << "tsumogiri"
        end
      end
      @client.send(cmd)
    end

    private

    # 鳴き
    def naki(hai, args)
      buttons = [ nil, nil, nil, :PASS, nil ]
      @sutehai = hai
      args.each { |arg|
        case arg
        when 'chi'
          buttons[0] = :CHI
        when 'pon'
          buttons[1] = :PON
        when 'kan'
          buttons[2] = :KAN
        when 'ron'
          buttons[4] = :RON
        end
      }
      set_button(*buttons)
    end

    def show_info(args)
      info = "#{Mahjong::Hai[args[0]].to_k}#{args[1][0] - ?A + 1}局"
      if args[2].to_i > 0
        info << " #{args[2]}本場"
      end
      if args[3].to_i > 0
        info << " 供託#{args[3]}"
      end
      @info.set_label(info)
    end

    #
    def get_player(arg)
      index = (arg[0] - @myself + PLAYER_MAX - 1) % PLAYER_MAX
      @player[index]
    end

    #
    def set_button(*buttons)
      BUTTON_MAX.times { |i|
        id = buttons[i]
        @buttons[i][0].set_label(id ? BUTTONS[id] : '-')
        @buttons[i][1] = id
      }
    end

    #
    def clicked_button(id)
      case id
      when :NOTEN
        @client.send('no')
      when :TENPAI
        @client.send('yes')
      when :CHI
        @mode = :CHI
      when :PON
        @client.send('pon', @sutehai.to_s, @sutehai.to_s)
      when :KAN
        if @sutehai
          @client.send('kan')
        else
          @mode = :KAN
        end
      when :RON
        @client.send('ron')
      when :TSUMO
        @client.send('tsumo')
      when :PASS
        @client.send('pass')
      when :RICHI
        @mode = :RICHI
      when :OK
        @client.send('ok')
      end
    end
  end
end
