##
#	$Id: client.rb 21 2008-11-16 18:27:54Z yatsuhashi $
#
require 'observer'
require 'mahjong'
require 'common/umpsocket'
require 'client/player.rb'

module OpenMj
  #
  class Client
    include Observable

    #
    def initialize(host = 'localhost', port = 1326)
      @socket = UMPSocket.open(host, port)
      @serial = nil
      @player = Hash.new
      @myself = nil
    end
    attr_reader :player

    #
    def start(&proc)
      while args = @socket.recv
        puts("> #{args.join(' ')}")
        @serial = args.shift
        command = args.shift
        case command
        when 'gamestart'
          @player.clear
          @myself = args[0][0] - ?A
          args[1 .. -1].each_with_index { |name, i|
            @player[(?A + i).chr] = Player.new(name)
          }
          changed
        when 'point'
          if match = /^=(\d+)$/.match(args[1])
            @player[args[0]].set_point(match[1].to_i)
          end
          changed
        when 'haipai'
          @player[args[0]].set_hand(args[1])
          changed
        when 'tsumo'
          @player[args[0]].hand.tsumo(Mahjong::Hai[args[2]])
          changed
        when 'sutehai'
          @player[args[0]].hand.sutehai(Mahjong::Hai[args[1]])
          changed
        end
        proc.call(command, args)
        if command == 'gameend'
          break
        end
      end
      @socket.close
    end

    #
    def send(*args)
      args.flatten!
      puts("< #{@serial} #{args.join(' ')}")
      @socket.send(@serial, *args)
    end

    #
    def get_player(index = 0)
      if @myself
        @player[((@myself + index) % @player.size + ?A).chr]
      end
    end
  end
end
