#!/usr/bin/ruby
# Copyright (c) 2010, Takaya Kakizaki(kacky)
# All rights reserved.
#
#  \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏𖞂ꍇɌAĔЕzюgp܂B 
#
#  E\[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 
#
#  EoCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 
#
#  Eʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔iɁAI[v̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB
#
#
#  {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v񋟂ĂAَ킸A
#  ƓIȎgp\Aѓ̖ړIɑ΂KɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂B
#  쌠҂Rgr[^[AR̂킸A Q̌킸AӔC̍_ł邩iӔCł邩
#  iߎ̑́js@sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂĂA{\tgEFA̎gpɂĔ
#  i֕i܂͑pT[rX̒BAgp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳Ȃj
#  ڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQɂāAؐӔC𕉂Ȃ̂Ƃ܂B 
require "comrexml"
require "kconv"
require "mahjongconst"

PAI_A = ["","","","k","","",""]

def getpainame(num)
  n = (num % 9) + 1
  
  if num < 9
    return "#{n}m"
  elsif num < 18
    return "#{n}p"
  elsif num < 27
    return "#{n}s"
  else
    return PAI_A[num-27]
  end
end


def mjscoreconv(iname,fd)
  # ID𓌕`֕ϊ
  idtable = [0,0,0,0]
  ifd = File.open(iname,File::RDWR)
  
  scoredata = ifd.readline
  
  ifd.close
  
  # OŌ(</log>)܂œBĂȂꍇ͋ǂ̍Ōɍ킹
  if !scoredata.rindex("</log>")
    scoredata = scoredata.slice(0,scoredata.rindex("</kyoku>") + 8)
    scoredata += "</log>"
  end
  
  tmp = iname.split("_")
  
  tid = tmp[0]
  date = tmp[1]
  suffix = tmp[2]
  
  year = date[0..3]
  month = date[4..5]
  day = date[6..7]
  hour = date[8..9]
  minute = date[10..11]
  
  
  # XMLƂăp[X
  doc = CommonXML::parseXML(scoredata)
  
  ele = doc.getRoot
  
  fd.puts("===== FLO #{tid} Jn #{year}/#{month}/#{day} #{hour}:#{minute} =====")
  is_first = true
  kyoku_a = ["1","2","3","4","1","2","3","4"]
  mangan_a = ["","nl","{","O{",""]
  han_a = ["","","O","l",""]
  
  ele.each_element("kyoku") { | item |
    # idɃ\[g
    member_a = []
    item.each_element("#{TAG_MEMBER}/") { | member |
      id = member.findFirstElement("#{TAG_PLAYER}/#{TAG_ID}")
      member_a[id.text.to_i] = member
    }
    
    if is_first
      fd.write("  _25000")
      
      for i in 0 .. member_a.length-1
        zikaze = member_a[i].findFirstElement(TAG_ZIKAZE).text.to_i
        idtable[zikaze-1] = i
      end
      
      for i in 0 .. member_a.length-1
        nm = member_a[idtable[i]].findFirstElement("#{TAG_PLAYER}/#{TAG_NAME}")
        fd.write(" [#{i+1}]#{nm.text.tosjis}_#{i+1} R1500")
      end
      
      fd.puts
      is_first = false
    end
    
    kc = kyoku_a[item.findFirstElement(TAG_KYOKUCOUNT).text.to_i]
    rb = item.findFirstElement(TAG_RIICHIBOU).text
    tb = item.findFirstElement(TAG_TSUMIBOU).text
    
    fd.write("  #{kc} #{tb}{([`#{rb})")
    
    res = item.findFirstElement(TAG_RESULT)
    
    res.each_element(TAG_PLAYER) { | player |
      score = player.findFirstElement(TAG_POINT).text.to_i
      nm = player.findFirstElement(TAG_NAME)
      id = idtable.index(player.findFirstElement(TAG_ID).text.to_i)
      if score != 0
        fd.write(" #{nm.text.tosjis}_#{id+1} #{score}")
      end
    }
    
    fd.puts
    
    tmp = res.findFirstElement(TAG_MANGAN)
    
    if tmp
      mangan = tmp.text.to_i - 1
    else
      mangan = -1
    end
    
    if res.findFirstElement("ronagari") || res.findFirstElement("tsumoagari")
      if mangan >= 0
        fd.write("    #{mangan_a[mangan]}")
      else
        han = res.findFirstElement(TAG_HAN).text.to_i
        fu = res.findFirstElement(TAG_FU).text.to_i
        
        fd.write("    #{fu} #{han_a[han-1]}")
        if res.findFirstElement("ronagari")
          fd.write("")
        else
          fd.write("c")
        end
        
      end
      
    else
      fd.write("   ")
    end
    
    yaku = res.findFirstElement(TAG_YAKU)
    fd.puts(" #{yaku.text.tosjis.gsub(/h /,"h")}")
    
    # zv̕\
    
    for i in 0 .. member_a.length-1
      id = idtable[i]
      zikaze = member_a[id].findFirstElement(TAG_ZIKAZE).text.to_i
      fd.write("    [#{i+1}#{PAI_A[zikaze-1]}]")
      member_a[id].each_element("#{TAG_TEHAI}/#{TAG_PAI}/num") { | pai |
        num = pai.text.to_i
        fd.write(getpainame(num))
      }
      fd.puts
    end
    
    # h̕\
    fd.write("    [\\h]")
    
    item.each_element("#{TAG_RESULT}/#{TAG_DORA}/#{TAG_PAI}/num") { | dora |
      fd.write(getpainame(dora.text.to_i))
    }
    
    fd.write(" [h]")
    
    item.each_element("#{TAG_RESULT}/#{TAG_URADORA}/#{TAG_PAI}/num") { | dora |
      fd.write(getpainame(dora.text.to_i))
    }
    
    fd.puts
    
    evcount = 0
    
    # Cxg̕\
    ev = item.findFirstElement("tsumo")
    
    while ev
      if evcount == 0
        fd.write("    *")
      end
      
      plid = ev.findFirstElement("#{TAG_PLAYER}/id")
      if plid
        plid = idtable.index(plid.text.to_i) + 1
      end
      
      paiid = ev.findFirstElement("#{TAG_PAI}/num")
      if paiid
        paiid = paiid.text.to_i
      end
      
      tsumogiri = ev.findFirstElement("#{TAG_PAI}/#{TAG_TSUMOGIRI}")
      if tsumogiri
        tsumogiri = eval(tsumogiri.text)
      else
        tsumogiri = false
      end
      
      mentsu = []
      mid = ev.each_element("#{TAG_MENTSU}/#{TAG_PAI}/num") { | pnum |
        mentsu << pnum.text.to_i
      }
      
      mentsu -= [paiid]
      
      case ev.getTagName
      when "tsumo"
        fd.write(" #{plid}G#{getpainame(paiid)}")
      when "ev"
        evid = ev.findFirstElement("id")
        case evid.text.to_i
        when ID_DAHAI .. ID_DAHAI + 13
          fd.write(" #{plid}#{tsumogiri ? "D" : "d"}#{getpainame(paiid)}")
        when ID_TII .. ID_PON - 1
          fd.write(" #{plid}C")
          for p in mentsu
            fd.write("#{getpainame(p)}")
          end
        when ID_PON .. ID_DAIMINKAN - 1
          fd.write(" #{plid}N")
        when ID_DAIMINKAN,ID_KAN .. ID_RIICHI - 1
          fd.write(" #{plid}K#{getpainame(paiid)}")
        when ID_RIICHI .. ID_RIICHI + 13
          fd.write(" #{plid}R")
          fd.write(" #{plid}#{tsumogiri ? "D" : "d"}#{getpainame(paiid)}")
        when ID_TSUMO,ID_RON
          fd.write(" #{plid}A")
        end
      else
        break
      end
      
      ev = ev.getNextSibling
      evcount = (evcount + 1) % 15
      
      if evcount == 0
        fd.puts
      end
      
    end
    
    fd.puts
  }
end

if ARGV[0]
  fd = File.open("mjscore.txt",File::WRONLY | File::CREAT | File::TRUNC)
  mjscoreconv(ARGV[0],fd)
  fd.close
else
  require "cgi"
  cgi = CGI.new
  puts "Content-type:text/plain;charset=shift-jis"
  puts
  mjscoreconv(cgi["file"],STDOUT)
end

