/*
 * OpenI2CRADIO
 * EUSART Handler
 * Copyright (C) 2013-11-07 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif
#include <signal.h>

#include "iodef.h"
#include "idle.h"
#include "ioports.h"
#include "euart.h"
#include "menu.h"
#include "uart_termio.h"
#include "shell_strutl.h"
#include "power.h"

unsigned char uart_term_putstr(unsigned char *s)
{
    unsigned char p = 0;
    if((uart_getstat() & UART_WAKEUP) == 0) return 0; // Error
    while(s[p] != 0x00)
    {
        uart_pushchar(s[p], 200); // Timeout = 10ms
        p++;
        if(p >= 255) return 0; // Overlen
    }
    return 0xff;
}

void uart_term_getstr(unsigned char *s, unsigned int timeout, unsigned char echo)
{
    unsigned int i = 0;
    unsigned char c = 0x00;
    unsigned int tim;
    unsigned char pwr;
    unsigned char cnt;
    tim = 0;
    cnt = 0;
    while(1){
        ClrWdt();
        c = uart_pullchar();
        if(c != 0x00) {
	    if(cnt > 10) {
		if(chk_powerbutton() != 0) {
		    shutdown(0xff);
		}
	       cnt = 0;
	    }
	    cnt++;
            if(echo != 0) uart_pushchar(c, 200); // Echoback
            if(c == '\b') { // BS
                if(i > 0) {
		   s[i] = '\0';
		   i--;
		}
            } else
            if(c < 0x80) {
	        s[i] = c;
                i++;
                if((c == '\t') || (c == '\n') || (c == '\r')) break; // TAB OR CR
                if(i >= 128) break;
            }
	    tim = 0;
       } else if(timeout != 0) { // ZAP n * 100mSec.
	    if(chk_powerbutton() != 0) shutdown(0xff); 
	    idle_time_ms(100 - 48); // Poll 0.1Sec
	    tim++;
	    if(tim > timeout) {
	       s[0] = TERM_CHAR_TIMEOUT;
	       i = 1;
	       break;
	    }
       } else {
	  idle_time_ms(100 - 48); // Wait 100ms if none (and no Timeout).
         if(chk_powerbutton() != 0) shutdown(0xff); 
       }
    }
    s[i] = '\0';
}



