/*
 * OpenI2CRADIO
 * Up-down UI routine.
 * Copyright (C) 2013-06-10 K.Ohta <whatisthis.sowhat ai gmail.com>
 * License: GPL2+LE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if defined(__SDCC)
#include <sdcc-lib.h>
#include <pic18fregs.h> /* ONLY FOR PIC18x */
#include <delay.h>
#else
#include <xc.h>
#endif
#include <signal.h>

#include "iodef.h"
#include "idle.h"
#include "i2c_io.h"
#include "akc6955.h"
#include "lcd_acm1602.h"
#include "ui.h"
#include "eeprom.h"
#include "ioports.h"
#include "menu.h"
#include "power.h"
#include "adc_int.h"

void setfreq_updown(unsigned char ctlword)
{
    switch(ctlword){
        case charcode_8: // Change band
                if(fm == 0){
                    amfreq_bank[amband] = amfreq;
                    if(amband >= AKC6955_BAND_MW4) {
                        amband = 0;
                    } else {
                        amband++;
                    }
                    amfreq = amfreq_bank[amband];
                akc6955_set_amband(amband);
                akc6955_set_freq(amfreq);
                idle_time_62_5ms(); // 62.5ms
                amband = akc6955_get_amband();
                amfreq = akc6955_get_freq();
            } else {
                    fmfreq_bank[fmband] = fmfreq;
                    if(fmband >= AKC6955_BAND_FMUSER) {
                        fmband = 0;
                    } else {
                        fmband++;
                    }
                    fmfreq = fmfreq_bank[fmband];
                    akc6955_set_fmband(fmband);
                    idle_time_62_5ms(); // 62.5ms
                    akc6955_set_freq(fmfreq);
                    fmband = akc6955_get_fmband();
                    fmfreq = akc6955_get_freq();
            }
            break;
        case charcode_2: // Change band
                if(fm == 0){
                    amfreq_bank[amband] = amfreq;
                    if(amband == 0) {
                        amband = AKC6955_BAND_MW4;
                    } else if(amband > AKC6955_BAND_MW4) {
                        amband = AKC6955_BAND_MW4;
                    } else {
                        amband--;
                    }
                    amfreq = amfreq_bank[amband];
                akc6955_set_amband(amband);
                akc6955_set_freq(amfreq);
                    idle_time_62_5ms(); // 62.5ms
                amband = akc6955_get_amband();
                amfreq = akc6955_get_freq();
            } else {
                    fmfreq_bank[fmband] = fmfreq;
                    if(fmband == 0) {
                       fmband = AKC6955_BAND_FMUSER;
                    } else if(fmband > AKC6955_BAND_FMUSER) {
                        fmband = AKC6955_BAND_FMUSER;
                    } else {
                        fmband--;
                    }
                    fmfreq = fmfreq_bank[fmband];
                    akc6955_set_fmband(fmband);
                    idle_time_62_5ms(); // 62.5ms
                    akc6955_set_freq(fmfreq);
                    fmband = akc6955_get_fmband();
                    fmfreq = akc6955_get_freq();
            }
            break;
        case charcode_4: // Down Freq;
            if(fm != 0){
                fmfreq = akc6955_down_freq(25); // DOWN 250KHz
            } else {
                 amfreq = akc6955_down_freq(30); // DOWN 30KHz
            }
            break;
        case charcode_6: // Down Freq;
            if(fm != 0){
    //            fmfreq += 10;
                fmfreq = akc6955_up_freq(25); // UP 250KHz
            } else {
    //            amfreq += 10;
                amfreq = akc6955_up_freq(30); // UP 30KHz
            }
            break;
        case charcode_9: // Down Fast;
            if(fm != 0){
      //          fmfreq += 50;
                fmfreq = akc6955_up_freq(50); // DOWN 500KHz
            } else {
      //          amfreq += 50;
                amfreq = akc6955_up_freq(100); // DOWN 100KHz
            }
            break;
        case charcode_7: // Down Fast;
            if(fm != 0){
//                fmfreq -= 50;
                fmfreq = akc6955_down_freq(50); // UP 500KHz
            } else {
//                amfreq -= 50;
                amfreq = akc6955_down_freq(100); // UP 10KHz
            }
            break;
        case charcode_1: // Down Slow;
            if(fm != 0){
  //              fmfreq -= 3;
                fmfreq = akc6955_down_freq(3); // DOWN 30KHz
            } else {
  //              amfreq -= 3;
                if(amband == AKC6955_BAND_MW2) {
                    amfreq = akc6955_down_freq(9);
                } else if(amband == AKC6955_BAND_MW3) {
                    amfreq = akc6955_down_freq(10);
                } else if(am_mode3k == 0x00) {
                    amfreq = akc6955_down_freq(3); // DOWN 50KHz
                } else {
                    amfreq = akc6955_down_freq(5); // DOWN 50KHz
                }
            }
            break;
        case charcode_3: // Down Slow;
            if(fm != 0){
//                fmfreq += 3;
                fmfreq = akc6955_up_freq(3); // UP 30KHz
            } else {
//                amfreq += 3;
                if(amband == AKC6955_BAND_MW2){
                    amfreq = akc6955_up_freq(9);
                } else if(amband == AKC6955_BAND_MW3) {
                    amfreq = akc6955_up_freq(10);
                } else if(am_mode3k == 0x00) {
                    amfreq = akc6955_up_freq(3); // DOWN 50KHz
                } else {
                    amfreq = akc6955_up_freq(5); // DOWN 50KHz
                }
            }
            break;
        case charcode_0: // Step
            if(fm == 0){
                if(am_mode3k == 0) {
                    am_mode3k = 0xff;
                } else {
                    am_mode3k = 0;
                }
                amfreq = akc6955_mode3k(am_mode3k);
            }
            break;
        case charcode_a: // Toggle FM
            toggle_amfm();
            break;
        case charcode_b:
            set_volume();
            break;
        case charcode_c:
            // Scan
            scan_start();
            break;
        case charcode_d:
            // FM Narrow/Wide
            set_stereo();
            break;
        case charcode_e: // Backlight ON/OFF
            if(backlight_counter > 0) {
	       backlight_counter = 0;
	    } else {
	       backlight_counter = backlight_long;
	    }
            break;
        case charcode_5:
            main_menu();
            break;
        case charcode_f:
            updown_help();
            _CLS();
            _LOCATE(0,0);
            break;
        default:
            break;
    }
}
