/*
 * OpenI2CRADIO
 * Internal ADCONVERTER Handler
 * Copyright (C) 2013-06-20 K.Ohta <whatisthis.sowhat ai gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2,
 *  or (at your option) any later version.
 *  This library / program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING. If not, write to the
 *  Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 *
 *  As a special exception, if you link this(includeed from sdcc) library
 *  with other files, some of which are compiled with SDCC,
 *  to produce an executable, this library does not by itself cause
 *  the resulting executable to be covered by the GNU General Public License.
 *  This exception does not however invalidate any other reasons why
 *  the executable file might be covered by the GNU General Public License.
 */

//#include "adc.h"
#include "adc_int.h"
void intadc_init(void)
{
#if defined(pic18f23k22) || defined(pic18f24k22) || defined(pic18f25k22) || defined(pic18f26k22) || \
     defined(_18F23K22)  || defined(_18F24K22)  || defined(_18F25K22)  || defined(_18F26K22)

    ANSELA = AN_A_VAL;
    ANSELB = AN_B_VAL;
    ANSELC = AN_C_VAL;
#endif
#if defined(pic18f23k20) || defined(pic18f24k20) || defined(pic18f25k20) || defined(pic18f26k20) || \
      defined(_18F23K20)  || defined(_18F24K20)  || defined(_18F25K20)  || defined(_18F26K20)

    ANSEL=  _ADC_INITF;
    ANSELH = _ADCH_INITF;
#endif
#if defined(pic18f43k20) || defined(pic18f44k20) || defined(pic18f45k20) || defined(pic18f46k20) || \
    defined(_18F43K20)  || defined(_18F44K20)  || defined(_18F45K20)  || defined(_18F46K20)
    ANSEL = 0x00;
    ANSELH = 0x00;
    ANSELbits._ADC_INITF = 1;
//    ANSELH = 0x00;;
#endif
    PIR1bits.ADIF = 0;
    PIE1bits.ADIE = 0;
    IPR1bits.ADIP = 1; // High
}



unsigned int polladc(void)
{
    unsigned int a;
    PIE1bits.ADIE = 0;
    PIR1bits.ADIF = 0;
    if(ADCON0bits.DONE){ // converting or not enable.
        return 0xffff;
    } else { // Done, Clear interrupt
        a = ((ADRESH << 8)  + ADRESL) & 0x03ff;
     ADCON0bits.GO_DONE = 0;
     ADCON0bits.ADON = 0;
     return a;
    }
}

/*
 *    ADCON1bits.VCFG1 = 0;
 *    ADCON1bits.VCFG0 = 0;
 *    ADCON2 = 0b10110110;
 */
void startadc(unsigned char ch)
{
    unsigned int ansel_val;
    unsigned char config1, config2;
#ifdef __SDCC
    adc_open(ch, ADC_FOSC_64, 0, ADC_FRM_RJUST | ADC_INT_OFF | ADC_VCFG_VDD_VSS | ADC_NVCFG_VSS | ADC_PVCFG_VDD);
    adc_setchannel(ch);
    adc_conv();
#else
    PIE1bits.ADIE = 0;
    PIR1bits.ADIF = 0;
    ADCON0 = 0;
    ADCON2 = 0b00000110; // 64OSC, Right
    ADCON1 = 0b00000000; // VREF+=VDD,VREF-=VSS
    ADCON2 |= 0b10111000; // TAQ=20TAD, Right
    if(ch < _REF_ADC) {
        ADCON0 = ch << 2;
        ansel_val = 0x0001 << ch;
//        ansel_val = 0x0080;
    } else {
        ADCON0 = 0b00111100; //0x0f << 2;
       ansel_val = 0x0000;
    }
    ANSELH = ansel_val >> 8;
    ANSEL = ansel_val & 0xff;
    ADCON0bits.ADON = 1;
    idle(160); // 64*20 = 1280clock = 160us
    ADCON0bits.GO_DONE = 1;
#endif
}

#ifdef __SDCC
void stopadc(void)
{
    ADCON0bits.GO_DONE = 0;
    PIR1bits.ADIF = 0;
    PIE1bits.ADIE = 0;
}
#endif

unsigned int polladc2(void)
{
    unsigned int a;
//    PIE1bits.ADIE = 0;
//    PIR1bits.ADIF = 0;
    do {
        idle(50); // wait about 50us
        a = polladc();
    } while(a  == 0xffff);
   return a;
}

// Masure raw battery voltage, Reference = 1.20V±4%
// Multiply = 39:13 = 4:1.
unsigned int adc_rawtobatt(unsigned int b, unsigned int reflevel)
{

    // raw = (reflevel[0.01V] * b) / 1024 * divide :divide = 4
    return ((b * 120) / reflevel) * 4;
}