<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" />
  <xsl:key name="ext" match="method/htmlExtend" use="htmlExtend" />
  <xsl:template match="/">
    <xsl:apply-templates select="javadoc" />
  </xsl:template>

  <xsl:template match="javadoc">
    <xsl:variable name="version" select="version" />
    <ROWSET tableName="GF25">
      <EXEC_SQL>delete from GF25 where VERNO = '<xsl:value-of select="$version" />'</EXEC_SQL>
      <xsl:for-each select="classDoc">
        <xsl:element name="ROW">
          <xsl:attribute name="num">
            <xsl:number level="any" format="1" count="classDoc" />
          </xsl:attribute>
          <VERNO><xsl:value-of select="$version" /></VERNO>
          <ATTCLASS><xsl:value-of select="attClass" /></ATTCLASS>
          <SEQ><xsl:value-of select="seq" /></SEQ>
          <ATTKEY><xsl:value-of select="attKey" /></ATTKEY>
          <VALUENAME><xsl:value-of select="valueName" /></VALUENAME>
          <DESCRIPTION><xsl:value-of select="description" /></DESCRIPTION>
          <CONTENTS><xsl:value-of select="contents" /></CONTENTS>
          <FORM_SAMPLE><xsl:value-of select="formSample" /></FORM_SAMPLE>
        </xsl:element>
      </xsl:for-each>
    </ROWSET>
  </xsl:template>

</xsl:stylesheet>
