/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.develop;

import java.util.List;
import java.util.Map;
import java.util.Calendar;
import org.opengion.hayabusa.develop.AbstractJspCreate;
import org.opengion.hayabusa.develop.JspConvertEntity;
import org.opengion.fukurou.xml.OGElement;

/**
 *
 * @author Administrator
 *
 */
public class JspCreate_COMMENT extends AbstractJspCreate {
	private List<JspConvertEntity> COMMENT_ROWS ;
	private boolean IS_NULL ;

	/**
	 * 初期化メソッド
	 *
	 * 内部で使用する JspConvertEntity の リスト のマップを受け取り、初期化を行います。
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、名前空間指定無しに変更します。
	 *
	 * @param	master	JspConvertEntityのリストのマップ
	 */
	@Override
	protected void init( final Map<String,List<JspConvertEntity>> master ) {
		COMMENT_ROWS = master.get("COMMENT");
//		IS_NULL = (COMMENT_ROWS == null || COMMENT_ROWS.isEmpty() );
		IS_NULL = !isNotEmpty( COMMENT_ROWS );
//		KEY = "og:comment";
		KEY = ":comment";		// 5.2.1.0 (2010/10/01) 名前空間指定無し
	}

	/**
	 * ファイル名から、処理対象かどうかを判断します。
	 *
	 * @param	name	処理対象のファイル名
	 *
	 * @return	処理対象なら true/ そうでなければ、false
	 */
	@Override
	protected boolean isExecute( final String name ) {
		return ( name != null && name.indexOf( "index" ) < 0 && name.indexOf( "forward" ) < 0 );
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) メソッドの引数を、OGAttributes から OGElement に変更します。
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、引数を使用するように変更します。
	 *
	 * @param ele OGElementエレメントオブジェクト
	 * @param	nameSpace	このドキュメントのnameSpace( og とか mis とか )
	 *
	 * @return	変換された文字列
	 * @throws Throwable 変換時のエラー
	 */
	@Override
	protected String execute( final OGElement ele , final String nameSpace )  throws Throwable {
		if( IS_NULL ) { return ""; }

		String ns = (nameSpace.length() == 0) ? "" : nameSpace + ":" ;	// 5.2.1.0 (2010/10/01) 名前空間

		JspConvertEntity ENTITY = COMMENT_ROWS.get(0);

		// TODO Auto-generated method stub
		//書き出す文字列を作成開始。
		StringBuilder sbTub = new StringBuilder();
//		sbTub.append( "<og:comment").append( CR );
		sbTub.append( "<" ).append( ns ).append( "comment").append( CR );
		sbTub.append( "\tsystem  = \""	).append( ENTITY.getNmSys()	).append( "\"" ).append( CR );
		sbTub.append( "\tpgid    = \""	).append( ENTITY.getPgid()	).append( "\"" ).append( CR );
		sbTub.append( "\ttitle   = \""	).append( ENTITY.getNmpg()	).append( "\"" ).append( CR );
		sbTub.append( "\tdate    = \""	).append( toDay()			).append( "\"" ).append( CR );
		sbTub.append( "\tauthor  = \""	).append( "Auto Create"		).append( "\"" ).append( CR );
		sbTub.append( "\ttext    = \""	).append( ""				).append( "\"" ).append( CR );
		sbTub.append( "\tversion = \""	).append( "001"				).append( "\"" ).append( CR );
		sbTub.append( "/>" ).append( CR );
		return sbTub.toString();
	}

	/**
	 * 現在の日付(yyyy/mm/dd)を取得。
	 *
	 * @return 現在の日付
	 */
	private String toDay(){
		 //インスタンス化
		 Calendar now = Calendar.getInstance();

		int year = now.get(Calendar.YEAR);
		int mm   = now.get(Calendar.MONTH) + 1;
		int dd   = now.get(Calendar.DATE);

		String month = String.valueOf( mm );
		if (mm < 10){
			month = "0" + month ;
		}
		String day = String.valueOf( dd );
		if (dd < 10){
			day = "0" + day ;
		}
		return year + "/" + month + "/" + day;
	}
}
