/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractRenderer;
import org.opengion.hayabusa.db.CellRenderer;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.Selection;
import org.opengion.hayabusa.db.Selection_RADIO;

/**
 * RADIO レンデラーは、カラムのデータをコードリソースに対応したラジオボタンの
 * 代替えラベルで表示する場合に使用するクラスです。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 3.5.1.0 (2003/10/03) 新規作成
 * @og.group データ表示
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Renderer_RADIO extends AbstractRenderer {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	private final Selection selection  ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Renderer_RADIO() {
		selection  = null;
	}

	/**
	 * デフォルトコンストラクター。
	 *
	 * @og.rev 3.5.4.2 (2003/12/15) makeCodeSelection メソッドを CodeSelectionクラスに変更。
	 * @og.rev 3.5.5.7 (2004/05/10) SelectionFactory を使用して、オブジェクト作成
	 * @og.rev 4.0.0 (2005/01/31) SelectionFactory ではなく、直接 Selection_RADIO を作成。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Renderer_RADIO( final DBColumn clm ) {
		selection = new Selection_RADIO( clm.getCodeData() );	// 4.0.0 (2005/01/31)
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellRendererオブジェクト
	 */
	public CellRenderer newInstance( final DBColumn clm ) {
		return new Renderer_RADIO( clm );
	}

	/**
	 * データの表示用文字列を返します。
	 *
	 * @param   value 入力値
	 *
	 * @return  データの表示用文字列
	 */
	@Override
	public String getValue( final String value ) {
		return "<pre class=\"RADIO\">" +
				selection.getRadioLabel( value ) +
				"</pre>" ;
	}
}
