/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.mail;

/**
 * メール受信処理で、１メール受信ごとに呼び出されるリスナークラスです。
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface MailReceiveListener {

	/**
	 * メール受信処理で、１メール受信ごとに呼び出されます。
	 * 処理結果を、boolean で返します。
	 *
	 * @param message MailMessageオブジェクト
	 *
	 * @return	処理結果(正常:true / 異常:false)
	 */
	boolean receive( MailMessage message ) ;
}
