<?php
///////////////////////////////////////////////////////////////////////////////////////
// opencart1.4.7【日本語版】
// opencart.jp
// twentyfour.php
// ver 1.0.0 Coding By sae  2010/04/01 10:29:00 seagreenzzz@gmail.com
// GPL ver 3
///////////////////////////////////////////////////////////////////////////////////////
class ControllerPaymentTwentyfour extends Controller{

	private $error = array();

	public function index(){
		//言語ファイルのロード
		$this->load->language('payment/twentyfour');

		//登録するモデルのロード
		$this->load->model('setting/setting');

		//入力内容が正しい場合は入力データをデータベースに登録する。登録後はリダイレクト
		if( ($this->request->server['REQUEST_METHOD'] == 'POST' ) && ( $this->validate() ) ){

			$this->load->model('setting/setting');

			$this->model_setting_setting->editSetting('twentyfour', $this->request->post );

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect(HTTPS_SERVER . 'index.php?route=extension/payment');

		}//if-end


		//タイトル
		$this->document->title = $this->language->get('heading_title');

		$this->data['heading_title'] = $this->language->get('heading_title');

		//表示項目文字列
		$this->data['entry_use_price'] = $this->language->get('entry_use_price');

		$this->data['entry_order_status'] = $this->language->get('entry_order_status');

		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');

		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$this->data['entry_a'] = $this->language->get('entry_a');

		$this->data['entry_action_url'] = $this->language->get('entry_action_url');

		$this->data['entry_status'] = $this->language->get('entry_status');

		$this->data['entry_title'] = $this->language->get('entry_title');
		//テキスト
		$this->data['text_result_url'] = $this->language->get('text_result_url');
		//有効
		$this->data['text_enabled'] = $this->language->get('text_enabled');
		//無効
		$this->data['text_disabled'] = $this->language->get('text_disabled');

		$this->data['text_all_zones'] = $this->language->get('text_all_zones');

		//ボタン
		$this->data['button_save'] = $this->language->get('button_save');

		$this->data['button_cancel'] = $this->language->get('button_cancel');

	//すでに入力した場合の値の保持（ＤＢにある場合はそれを・・・POSTされてある場合は、それを優先）
		if (isset($this->request->post['twentyfour_use_price'])) {
			$this->data['twentyfour_use_price'] = $this->request->post['twentyfour_use_price'];
		} else {
			$this->data['twentyfour_use_price'] = $this->config->get('twentyfour_use_price');
		}

		if (isset($this->request->post['twentyfour_title'])) {
			$this->data['twentyfour_title'] = $this->request->post['twentyfour_title'];
		} else {
			$this->data['twentyfour_title'] = $this->config->get('twentyfour_title');
		}

		if (isset($this->request->post['twentyfour_sort_order'])) {
			$this->data['twentyfour_sort_order'] = $this->request->post['twentyfour_sort_order'];
		} else {
			$this->data['twentyfour_sort_order'] = $this->config->get('twentyfour_sort_order');
		}

		if (isset($this->request->post['twentyfour_a'])) {
			$this->data['twentyfour_a'] = $this->request->post['twentyfour_a'];
		} else {
			$this->data['twentyfour_a'] = $this->config->get('twentyfour_a');
		}

		if (isset($this->request->post['twentyfour_action_url'])) {
			$this->data['twentyfour_action_url'] = $this->request->post['twentyfour_action_url'];
		} else {
			$this->data['twentyfour_action_url'] = $this->config->get('twentyfour_action_url');
		}

		if (isset($this->request->post['twentyfour_status'])) {
			$this->data['twentyfour_status'] = $this->request->post['twentyfour_status'];
		} else {
			$this->data['twentyfour_status'] = $this->config->get('twentyfour_status');
		}

		//現在登録されているオーダーステータスを取得する
		$this->load->model('localisation/order_status');

		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['twentyfour_order_status_id'])) {
			$this->data['twentyfour_order_status_id'] = $this->request->post['twentyfour_order_status_id'];
		} else {
			$this->data['twentyfour_order_status_id'] = $this->config->get('twentyfour_order_status_id');
		}

		//ジオゾーン
		$this->load->model('localisation/geo_zone');

		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['twentyfour_geo_zone_id'])) {
			$this->data['twentyfour_geo_zone_id'] = $this->request->post['twentyfour_geo_zone_id'];
		} else {
			$this->data['twentyfour_geo_zone_id'] = $this->config->get('twentyfour_geo_zone_id');
		}

		//パンくず作成
		$this->document->breadcrumbs = array();
		//ホーム
   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=common/home',
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);
		//支払方法設定
   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=extension/payment',
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);
		//24カード決済ＪＰページ
   		$this->document->breadcrumbs[] = array(
       		'href'      => HTTPS_SERVER . 'index.php?route=payment/twentyfour',
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);

   		//登録の場合のアクションＵＲＬ（ボタンに必要）
		$this->data['action'] = HTTPS_SERVER . 'index.php?route=payment/twentyfour';
		//キャンセルの場合のアクションＵＲＬ
		$this->data['cancel'] = HTTPS_SERVER . 'index.php?route=extension/payment';

		//エラーの文言の処理
		if( isset($this->error['warning']) ){
			$this->data['error_warning'] = $this->error['warning'];
		}else{
			$this->data['error_warning'] = '';
		}

		if( isset($this->error['title']) ){
			$this->data['error_title'] = $this->error['title'];
		}else{
			$this->data['error_title'] = '';
		}

		if( isset($this->error['a']) ){
			$this->data['error_a'] = $this->error['a'];
		}else{
			$this->data['error_a'] = '';
		}

		if( isset($this->error['action_url']) ){
			$this->data['error_action_url'] = $this->error['action_url'];
		}else{
			$this->data['error_action_url'] = '';
		}

		//画面への出力
		$this->template = 'payment/twentyfour.tpl';

		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));

	}//function-end

//入力値のバリデート
	private function validate(){

		if(!$this->user->hasPermission('modify', 'payment/twentyfour')){
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if(!$this->request->post['twentyfour_title']){
			$this->error['title'] = $this->language->get('error_title');
		}

		if(!$this->request->post['twentyfour_a']){
			$this->error['a'] = $this->language->get('error_a');
		}

		if(!$this->request->post['twentyfour_action_url']){
			$this->error['action_url'] = $this->language->get('error_action_url');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}

	}//function-end

}

?>