package models.services
import forms._
import models._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._


case class NotifyManager() extends AbstractManager{
  def insert(notify: NotifyForm, notifyType: Long, partId: Long, designChangeId: Long, paramState: Int):Notify = {
    var insertNotify = Notify(notify.message, notify.atach, UserManager().getByName(notify.users.name).id, notifyType, partId, designChangeId, paramState)
    if(partId != 0) {
      insertNotify = PartManager().getById(partId).notifies.associate(insertNotify)
      
      } else if(designChangeId != 0) {
      insertNotify = DesignChangeManager().getById(designChangeId).notifies.associate(insertNotify)
     }
    return insertNotify
  }
  
  def update(notify: Notify) = {
    PartsListDb.notifies.update(notify)
  }
  
  def getById(id: Long): Notify ={
    PartsListDb.notifies.where(n => n.id === id).head
  }

}