package models
import org.squeryl._
import org.squeryl.dsl._
import org.squeryl.dsl.ast._
import org.squeryl.PrimitiveTypeMode._
case class PartRelation (val parentId:Long, val childId:Long, var quantity: Long, var delDcId: Long, var addDcId: Long) extends KeyedEntity[CompositeKey2[Long, Long]] {
  def id = compositeKey(parentId, childId)
  
  lazy val delRelation:ManyToOne[DesignChange] = PartsListDb.designChangeDelRelations.right(this)
  lazy val addRelation:ManyToOne[DesignChange] = PartsListDb.designChangeAddRelations.right(this)
  lazy val parent:ManyToOne[Part] = PartsListDb.relationParentParts.right(this)
  lazy val child:ManyToOne[Part] = PartsListDb.relationChildParts.right(this)
}