package models
import org.squeryl.KeyedEntity
import org.squeryl.dsl._
import org.squeryl.PrimitiveTypeMode._
case class Project(var name: String) extends KeyedEntity[Long] {
  val id:Long=0
  
  lazy val users = PartsListDb.projectMembers.left(this)
  lazy val parts : OneToMany[Part] = PartsListDb.projectParts.left(this)

  def projectMembers(uId: Long):ProjectMembers = PartsListDb.projectMembers.where(pm => pm.projectId === this.id and pm.userId === uId).head
}