package controllers
import play.api._
import play.api.mvc._
import play.api.data._
import play.api.data.Forms._
import forms._
import models._
import models.services._
import infra.services._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import scala.collection.mutable.ArrayBuffer
object ReplyController extends Controller{
  val replyRegistForm = Form(
      mapping(
          "message" -> nonEmptyText,
          "users" -> mapping (
              "name" -> nonEmptyText
            )(UserForm.apply)(UserForm.unapply),
            "atach" -> mapping {
                "grpName" -> text
              }(AtachForm.apply)(AtachForm.unapply)
        )(ReplyForm.apply)(ReplyForm.unapply)
   )
   
  def createReply(notifyId: Long, replyId: Long, notifyType: Long, replyType: Long, partId: Long, state: Long) = Action { implicit request =>
    Ok(views.html.createReplyForm(replyRegistForm, notifyId, replyId, replyType, partId, notifyType, state))
  }
  
  def replyRegistration(notifyId: Long, replyId: Long, partId: Long, notifyType: Long, state: Long) = Action(parse.multipartFormData) { implicit request =>
    replyRegistForm.bindFromRequest.fold(
        formWithErrors => BadRequest(views.html.createReplyForm(formWithErrors, notifyId, replyId, 0, partId, notifyType, state)),
        reply => {
          inTransaction {
            val replyUser = PartsListDb.users.where(u => u.name like reply.users.name + "%").head
            val newReply = PartsListDb.replies.insert(Reply(reply.message, replyUser.id, notifyId, replyId, reply.atach))
            var usersBuffer = ArrayBuffer[User]()
            request.body.file("atach").map { atach =>
              	AtachManager().uploadAtach(atach, newReply.atach.grpName, 0, 0, newReply.id)
              }
            var notify: Notify = null
            if(notifyId!=0) {
            	// 通知直下のreplyの場合、notifyより対象Partを割り出し、プロジェクトユーザー抽出。メイル通知。
            	notify = PartsListDb.notifies.where(n => n.id === notifyId).head
            } else {
              // reply配下のreplyの場合、再帰処理によりnotify抽出後、対象Partを割り出し、プロジェクトユーザー抽出。メイル通知。
              val targetReply = PartsListDb.replies.where(tr => tr.id === replyId).head
            	val topReply = upRecursion(targetReply)
            	notify = PartsListDb.notifies.where(n => n.id === topReply.notifyId).head              
              }
              // 部品表通知/依頼の回答であれば、Notifyが紐付くPartのプロジェクトメンバにメイル通知。
            if(notifyType == 0 || notifyType == 1) {
            	val targetPart = notify.part.assign(notify.part.head)
            	val users = targetPart.project.assign(targetPart.project.head).users
            	val sendMail = SendMail(2, replyUser.email, targetPart.id, 0, notifyType, state)
            	for(user <- users) {
            		sendMail.sendMail(user.email)
            	}
              }
              // 設計変更通知/依頼の回答であれば、Notifyが紐付くDesin ChangeのdelRelation、addRelationの全ての上品番、
              // 子品番のプロジェクトメンバにメイル通知。
            if(notifyType == 3 || notifyType == 4) {
                //設計変更対象リレーションの抽出
              val targetRelations = notify.designCgange.assign(notify.designCgange.head).delPartRelation.++:(notify.designCgange.assign(notify.designCgange.head).addPartRelation)
                //各リレーションの上位品番と子品番のプロジェクトメンバー抽出
              for(targetRelation <- targetRelations) {
                var users = targetRelation.parent.head.project.assign(targetRelation.parent.head.project.head).users
                users.copyToBuffer(usersBuffer)
                users = targetRelation.child.head.project.assign(targetRelation.child.head.project.head).users
                users.copyToBuffer(usersBuffer)
                }
              val sendMail = SendMail(2, replyUser.email, 0, notify.designCgange.head.id, notifyType, state)
              for(user <- usersBuffer.distinct) {
                sendMail.sendMail(user.email)
              	}
              }
           }
          Ok(views.html.issueresult(2, notifyType))
         }
     )
  }
  
  def showReply(id: Long, partId: Long, notifyType: Long, replyType: Long, state: Long) = Action { implicit request =>
    inTransaction {
      val reply = PartsListDb.replies.where(r => r.id === id).head
      val replyForm = ReplyForm(reply.message, UserForm(reply.user.assign(reply.user.head).name), null)
      Ok(views.html.showReplyForm(replyRegistForm.fill(replyForm), id, partId, notifyType, replyType, state, reply))
    }
  }
  
  def upRecursion(reply: Reply):Reply = {
    if(reply.parentReply.size == 0) {
      return reply
    } else {
      println("Messages " + reply.message)
      upRecursion(reply.parentReply.head)
    }
  }
  
  def appendAtach(id: Long, partId: Long, notifyType: Long, replyType: Long, state: Long) = Action(parse.multipartFormData) { implicit request =>
    replyRegistForm.bindFromRequest.fold(
        formWithErrors => BadRequest(views.html.showReplyForm(formWithErrors, id, partId, notifyType, replyType, state, null)),
//        formWithErrors => BadRequest(views.html.error(formWithErrors)),
        reply => {
          inTransaction {
            request.body.file("atach").map { atach =>
              	AtachManager().uploadAtach(atach, reply.atach.grpName, 0, 0, id)
              }
            Redirect(routes.ReplyController.showReply(id, partId, notifyType, replyType, state))
            }
          }
     )
  }
}