/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import oauth.signpost.AbstractOAuthConsumer;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthProvider;
import oauth.signpost.exception.OAuthException;
import oauth.signpost.http.HttpRequest;
import play.libs.WS;

public class OAuth {
    private ServiceInfo info;
    private OAuthProvider provider;

    public OAuth(ServiceInfo serviceInfo) {
        this(serviceInfo, true);
    }

    public OAuth(ServiceInfo serviceInfo, boolean bl) {
        this.info = serviceInfo;
        this.provider = new CommonsHttpOAuthProvider(serviceInfo.requestTokenURL, serviceInfo.accessTokenURL, serviceInfo.authorizationURL);
        this.provider.setOAuth10a(bl);
    }

    public ServiceInfo getInfo() {
        return this.info;
    }

    public OAuthProvider getProvider() {
        return this.provider;
    }

    public RequestToken retrieveRequestToken(String string) {
        DefaultOAuthConsumer defaultOAuthConsumer = new DefaultOAuthConsumer(this.info.key.key, this.info.key.secret);
        try {
            this.provider.retrieveRequestToken((OAuthConsumer)defaultOAuthConsumer, string, new String[0]);
            return new RequestToken(defaultOAuthConsumer.getToken(), defaultOAuthConsumer.getTokenSecret());
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException(oAuthException);
        }
    }

    public RequestToken retrieveAccessToken(RequestToken requestToken, String string) {
        DefaultOAuthConsumer defaultOAuthConsumer = new DefaultOAuthConsumer(this.info.key.key, this.info.key.secret);
        defaultOAuthConsumer.setTokenWithSecret(requestToken.token, requestToken.secret);
        try {
            this.provider.retrieveAccessToken((OAuthConsumer)defaultOAuthConsumer, string, new String[0]);
            return new RequestToken(defaultOAuthConsumer.getToken(), defaultOAuthConsumer.getTokenSecret());
        }
        catch (OAuthException oAuthException) {
            throw new RuntimeException(oAuthException);
        }
    }

    public String redirectUrl(String string) {
        return oauth.signpost.OAuth.addQueryParameters((String)this.provider.getAuthorizationWebsiteUrl(), (String[])new String[]{"oauth_token", string});
    }

    public static class WSRequestAdapter
    implements HttpRequest {
        private WS.WSRequest request;

        public WSRequestAdapter(WS.WSRequest wSRequest) {
            this.request = wSRequest;
        }

        public Object unwrap() {
            return this.request;
        }

        public Map<String, String> getAllHeaders() {
            return Maps.transformValues(this.request.getAllHeaders(), (Function)new Function<List<String>, String>(){

                public String apply(List<String> list) {
                    if (list.size() == 0) {
                        return "";
                    }
                    return list.get(list.size() - 1);
                }
            });
        }

        public String getHeader(String string) {
            List<String> list = this.request.getHeader(string);
            if (list.size() == 0) {
                return "";
            }
            return list.get(list.size() - 1);
        }

        public String getContentType() {
            return this.getHeader("Content-Type");
        }

        public InputStream getMessagePayload() {
            return null;
        }

        public String getMethod() {
            return this.request.getMethod();
        }

        public void setHeader(String string, String string2) {
            this.request.setHeader(string, string2);
        }

        public String getRequestUrl() {
            return this.request.getUrl();
        }

        public void setRequestUrl(String string) {
            this.request.setUrl(string);
        }
    }

    public static class OAuthCalculator
    extends AbstractOAuthConsumer
    implements WS.SignatureCalculator {
        public OAuthCalculator(ConsumerKey consumerKey, RequestToken requestToken) {
            super(consumerKey.key, consumerKey.secret);
            this.setTokenWithSecret(requestToken.token, requestToken.secret);
        }

        protected HttpRequest wrap(Object object) {
            if (object instanceof WS.WSRequest) {
                return new WSRequestAdapter((WS.WSRequest)((Object)object));
            }
            throw new IllegalArgumentException("OAuthCalculator expects requests of type play.libs.WS.WSRequest");
        }

        @Override
        public void sign(WS.WSRequest wSRequest) {
            try {
                this.sign(this.wrap((Object)wSRequest));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static class ServiceInfo {
        public String requestTokenURL;
        public String accessTokenURL;
        public String authorizationURL;
        public ConsumerKey key;

        public ServiceInfo(String string, String string2, String string3, ConsumerKey consumerKey) {
            this.requestTokenURL = string;
            this.accessTokenURL = string2;
            this.authorizationURL = string3;
            this.key = consumerKey;
        }
    }

    public static class RequestToken {
        public String token;
        public String secret;

        public RequestToken(String string, String string2) {
            this.token = string;
            this.secret = string2;
        }
    }

    public static class ConsumerKey {
        public String key;
        public String secret;

        public ConsumerKey(String string, String string2) {
            this.key = string;
            this.secret = string2;
        }
    }
}

