/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm.impl;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import tyrex.tm.impl.CloudscapeXAResourceHelper;
import tyrex.tm.impl.InformixXAResourceHelper;
import tyrex.tm.impl.OracleXAResourceHelper;
import tyrex.tm.impl.XAResourceHelper;

final class XAResourceHelperManager {
    private static final XAResourceHelper _defaultHelper = new XAResourceHelper();
    private static XAResourceHelper _oracleHelper;
    private static XAResourceHelper _cloudscapeHelper;
    private static XAResourceHelper _informixHelper;
    private static final String _oracleXAResourceClassName = "oracle.jdbc.xa.client.OracleXAResource";
    static final String _oracleXAExceptionClassName = "oracle.jdbc.xa.OracleXAException";
    private static final String _cloudscapeXAResourceClassName = "c8e.bm.a";
    private static final String _informixXAResourceClassName = "com.informix.jdbcx.IfxXAResource";

    private XAResourceHelperManager() {
    }

    static XAResourceHelper getHelper(XAResource xAResource) {
        String string = xAResource.getClass().getName();
        if (string.equals(_oracleXAResourceClassName)) {
            String string2 = _oracleXAResourceClassName;
            synchronized (string2) {
                if (null == _oracleHelper) {
                    _oracleHelper = new OracleXAResourceHelper();
                }
                XAResourceHelper xAResourceHelper = _oracleHelper;
                return xAResourceHelper;
            }
        }
        if (string.equals(_cloudscapeXAResourceClassName)) {
            String string3 = _cloudscapeXAResourceClassName;
            synchronized (string3) {
                if (null == _cloudscapeHelper) {
                    _cloudscapeHelper = new CloudscapeXAResourceHelper();
                }
                XAResourceHelper xAResourceHelper = _cloudscapeHelper;
                return xAResourceHelper;
            }
        }
        if (string.equals(_informixXAResourceClassName)) {
            String string4 = _informixXAResourceClassName;
            synchronized (string4) {
                if (null == _informixHelper) {
                    _informixHelper = new InformixXAResourceHelper();
                }
                XAResourceHelper xAResourceHelper = _informixHelper;
                return xAResourceHelper;
            }
        }
        return _defaultHelper;
    }

    static XAResourceHelper getHelper(XAException xAException) {
        if (xAException.getClass().getName().equals(_oracleXAExceptionClassName)) {
            String string = _oracleXAResourceClassName;
            synchronized (string) {
                if (null == _oracleHelper) {
                    _oracleHelper = new OracleXAResourceHelper();
                }
                XAResourceHelper xAResourceHelper = _oracleHelper;
                return xAResourceHelper;
            }
        }
        return _defaultHelper;
    }
}

