/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.ActorCell;
import akka.actor.ActorRef;
import akka.actor.dungeon.AbstractActorCell;
import akka.dispatch.Create;
import akka.dispatch.Envelope$;
import akka.dispatch.Mailbox;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.NullMessage$;
import akka.dispatch.Recreate;
import akka.dispatch.Resume;
import akka.dispatch.Supervise;
import akka.dispatch.Suspend;
import akka.dispatch.SystemMessage;
import akka.dispatch.Terminate;
import akka.event.Logging;
import akka.util.Unsafe;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public abstract class Dispatch$class {
    public static final Mailbox mailbox(ActorCell $this) {
        return (Mailbox)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.mailboxOffset);
    }

    public static final Mailbox swapMailbox(ActorCell $this, Mailbox newMailbox) {
        while (true) {
            Mailbox oldMailbox;
            if (!Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.mailboxOffset, oldMailbox = $this.mailbox(), newMailbox)) continue;
            return oldMailbox;
        }
    }

    public static final boolean hasMessages(ActorCell $this) {
        return $this.mailbox().hasMessages();
    }

    public static final int numberOfMessages(ActorCell $this) {
        return $this.mailbox().numberOfMessages();
    }

    public static final MessageDispatcher getDispatcher(ActorCell $this) {
        return $this.dispatcher();
    }

    public static final boolean isTerminated(ActorCell $this) {
        return $this.mailbox().isClosed();
    }

    public static final ActorCell init(ActorCell $this, int uid, boolean sendSupervise) {
        $this.swapMailbox($this.dispatcher().createMailbox($this));
        $this.mailbox().setActor($this);
        $this.mailbox().systemEnqueue($this.self(), new Create(uid));
        if (sendSupervise) {
            $this.parent().sendSystemMessage(new Supervise($this.self(), false, uid));
            NullMessage$ x$1 = NullMessage$.MODULE$;
            ActorRef x$2 = $this.parent().$bang$default$2(x$1);
            $this.parent().$bang(x$1, x$2);
        }
        return $this;
    }

    public static final ActorCell start(ActorCell $this) {
        $this.dispatcher().attach($this);
        return $this;
    }

    public static final void suspend(ActorCell $this) {
        Throwable throwable2;
        block6: {
            try {
                $this.dispatcher().systemDispatch($this, new Suspend());
            }
            catch (Throwable throwable2) {
                boolean bl;
                Throwable x6 = throwable2;
                if (x6 instanceof InterruptedException) {
                    InterruptedException x9 = (InterruptedException)x6;
                    bl = true;
                } else {
                    Option o19 = NonFatal$.MODULE$.unapply(x6);
                    if (o19.isEmpty()) {
                        bl = false;
                    } else {
                        Throwable p7 = (Throwable)o19.get();
                        bl = true;
                    }
                }
                if (!bl) break block6;
                $this.system().eventStream().publish(new Logging.Error(x6, $this.self().path().toString(), $this.clazz($this.actor()), "swallowing exception during message send"));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public static final void resume(ActorCell $this, Throwable causedByFailure) {
        Throwable throwable2;
        block6: {
            try {
                $this.dispatcher().systemDispatch($this, new Resume(causedByFailure));
            }
            catch (Throwable throwable2) {
                boolean bl;
                Throwable x6 = throwable2;
                if (x6 instanceof InterruptedException) {
                    InterruptedException x9 = (InterruptedException)x6;
                    bl = true;
                } else {
                    Option o19 = NonFatal$.MODULE$.unapply(x6);
                    if (o19.isEmpty()) {
                        bl = false;
                    } else {
                        Throwable p7 = (Throwable)o19.get();
                        bl = true;
                    }
                }
                if (!bl) break block6;
                $this.system().eventStream().publish(new Logging.Error(x6, $this.self().path().toString(), $this.clazz($this.actor()), "swallowing exception during message send"));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public static final void restart(ActorCell $this, Throwable cause) {
        Throwable throwable2;
        block6: {
            try {
                $this.dispatcher().systemDispatch($this, new Recreate(cause));
            }
            catch (Throwable throwable2) {
                boolean bl;
                Throwable x6 = throwable2;
                if (x6 instanceof InterruptedException) {
                    InterruptedException x9 = (InterruptedException)x6;
                    bl = true;
                } else {
                    Option o19 = NonFatal$.MODULE$.unapply(x6);
                    if (o19.isEmpty()) {
                        bl = false;
                    } else {
                        Throwable p7 = (Throwable)o19.get();
                        bl = true;
                    }
                }
                if (!bl) break block6;
                $this.system().eventStream().publish(new Logging.Error(x6, $this.self().path().toString(), $this.clazz($this.actor()), "swallowing exception during message send"));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public static final void stop(ActorCell $this) {
        Throwable throwable2;
        block6: {
            try {
                $this.dispatcher().systemDispatch($this, new Terminate());
            }
            catch (Throwable throwable2) {
                boolean bl;
                Throwable x6 = throwable2;
                if (x6 instanceof InterruptedException) {
                    InterruptedException x9 = (InterruptedException)x6;
                    bl = true;
                } else {
                    Option o19 = NonFatal$.MODULE$.unapply(x6);
                    if (o19.isEmpty()) {
                        bl = false;
                    } else {
                        Throwable p7 = (Throwable)o19.get();
                        bl = true;
                    }
                }
                if (!bl) break block6;
                $this.system().eventStream().publish(new Logging.Error(x6, $this.self().path().toString(), $this.clazz($this.actor()), "swallowing exception during message send"));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public static void tell(ActorCell $this, Object message, ActorRef sender) {
        Throwable throwable2;
        block6: {
            try {
                $this.dispatcher().dispatch($this, Envelope$.MODULE$.apply(message, sender == null ? $this.system().deadLetters() : sender, $this.system()));
            }
            catch (Throwable throwable2) {
                boolean bl;
                Throwable x6 = throwable2;
                if (x6 instanceof InterruptedException) {
                    InterruptedException x9 = (InterruptedException)x6;
                    bl = true;
                } else {
                    Option o19 = NonFatal$.MODULE$.unapply(x6);
                    if (o19.isEmpty()) {
                        bl = false;
                    } else {
                        Throwable p7 = (Throwable)o19.get();
                        bl = true;
                    }
                }
                if (!bl) break block6;
                $this.system().eventStream().publish(new Logging.Error(x6, $this.self().path().toString(), $this.clazz($this.actor()), "swallowing exception during message send"));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public static void sendSystemMessage(ActorCell $this, SystemMessage message) {
        Throwable throwable2;
        block6: {
            try {
                $this.dispatcher().systemDispatch($this, message);
            }
            catch (Throwable throwable2) {
                boolean bl;
                Throwable x6 = throwable2;
                if (x6 instanceof InterruptedException) {
                    InterruptedException x9 = (InterruptedException)x6;
                    bl = true;
                } else {
                    Option o19 = NonFatal$.MODULE$.unapply(x6);
                    if (o19.isEmpty()) {
                        bl = false;
                    } else {
                        Throwable p7 = (Throwable)o19.get();
                        bl = true;
                    }
                }
                if (!bl) break block6;
                $this.system().eventStream().publish(new Logging.Error(x6, $this.self().path().toString(), $this.clazz($this.actor()), "swallowing exception during message send"));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$dungeon$Dispatch$_setter_$dispatcher_$eq($this.system().dispatchers().lookup($this.props().dispatcher()));
    }
}

