/*
 * Decompiled with CFR 0.152.
 */
package tyrex.naming;

import java.io.PrintWriter;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import tyrex.naming.MemoryContext;

public final class MemoryBinding {
    public static final int INITIAL_CAPACITY = 11;
    public static final int MAXIMUM_CAPACITY = 191;
    public static final float LOAD_FACTOR = 0.75f;
    private String _name = "";
    protected MemoryBinding _parent;
    private int _count;
    private int _threshold = 8;
    private BindingEntry[] _hashTable = new BindingEntry[11];

    public Context getContext() {
        return new MemoryContext(this, null);
    }

    public synchronized Object get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._hashTable.length;
        BindingEntry bindingEntry = this._hashTable[n2];
        while (bindingEntry != null) {
            if (bindingEntry._hashCode == n && bindingEntry._name.equals(string)) {
                return bindingEntry._value;
            }
            bindingEntry = bindingEntry._next;
        }
        return null;
    }

    public synchronized void put(String string, Object object) {
        int n;
        int n2;
        BindingEntry bindingEntry;
        if (string == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        if (object == null) {
            throw new IllegalArgumentException("Argument value is null");
        }
        if (object instanceof MemoryBinding) {
            ((MemoryBinding)object)._parent = this;
            ((MemoryBinding)object)._name = string;
        }
        if ((bindingEntry = this._hashTable[n2 = ((n = string.hashCode()) & Integer.MAX_VALUE) % this._hashTable.length]) == null) {
            this._hashTable[n2] = bindingEntry = new BindingEntry(string, n, object);
            ++this._count;
        } else {
            if (bindingEntry._hashCode == n && bindingEntry._name.equals(string)) {
                bindingEntry._value = object;
                return;
            }
            BindingEntry bindingEntry2 = bindingEntry._next;
            while (bindingEntry2 != null) {
                if (bindingEntry2._hashCode == n && bindingEntry2._name.equals(string)) {
                    bindingEntry2._value = object;
                    return;
                }
                bindingEntry = bindingEntry2;
                bindingEntry2 = bindingEntry2._next;
            }
            bindingEntry._next = new BindingEntry(string, n, object);
            ++this._count;
        }
        if (this._count >= this._threshold) {
            this.rehash();
        }
    }

    public synchronized Object remove(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Argument name is null");
        }
        int n = string.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % this._hashTable.length;
        BindingEntry bindingEntry = this._hashTable[n2];
        if (bindingEntry == null) {
            return null;
        }
        if (bindingEntry._hashCode == n && bindingEntry._name.equals(string)) {
            this._hashTable[n2] = bindingEntry._next;
            --this._count;
            return bindingEntry._value;
        }
        BindingEntry bindingEntry2 = bindingEntry._next;
        while (bindingEntry2 != null) {
            if (bindingEntry2._hashCode == n && bindingEntry2._name.equals(string)) {
                bindingEntry._next = bindingEntry2._next;
                --this._count;
                return bindingEntry2._value;
            }
            bindingEntry = bindingEntry2;
            bindingEntry2 = bindingEntry2._next;
        }
        return null;
    }

    public String getName() {
        if (this._parent != null && this._parent.getName().length() > 0) {
            return this._parent.getName() + "/" + this._name;
        }
        return this._name;
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public boolean isEmpty() {
        return this._count == 0;
    }

    public void destroy() {
        this._hashTable = null;
    }

    void debug(PrintWriter printWriter) {
        this.debug(printWriter, 0);
    }

    private synchronized void debug(PrintWriter printWriter, int n) {
        int n2 = n;
        while (n2-- > 0) {
            printWriter.print("  ");
        }
        if (this instanceof MemoryBinding) {
            printWriter.println("MemoryBinding: " + this.getName());
        } else {
            printWriter.println("ThreadedBinding: " + this.getName());
        }
        if (this._count == 0) {
            printWriter.println("Empty");
        } else {
            int n3 = this._hashTable.length;
            while (n3-- > 0) {
                BindingEntry bindingEntry = this._hashTable[n3];
                while (bindingEntry != null) {
                    int n4 = n;
                    while (n4-- > 0) {
                        printWriter.print("  ");
                    }
                    Object object = bindingEntry._value;
                    if (object instanceof MemoryBinding) {
                        ((MemoryBinding)object).debug(printWriter, n + 1);
                    } else {
                        printWriter.println("  " + bindingEntry._name + " = " + object);
                    }
                    bindingEntry = bindingEntry._next;
                }
            }
        }
    }

    protected NamingEnumeration enumerate(Context context, boolean bl) {
        return new MemoryBindingEnumeration(context, bl);
    }

    private void rehash() {
        int n = this._hashTable.length * 2 + 1;
        if (n > 191) {
            this._threshold = Integer.MAX_VALUE;
            return;
        }
        BindingEntry[] bindingEntryArray = new BindingEntry[n];
        int n2 = this._hashTable.length;
        while (n2-- > 0) {
            BindingEntry bindingEntry = this._hashTable[n2];
            while (bindingEntry != null) {
                BindingEntry bindingEntry2 = bindingEntry._next;
                int n3 = (bindingEntry._hashCode & Integer.MAX_VALUE) % n;
                bindingEntry._next = bindingEntryArray[n3];
                bindingEntryArray[n3] = bindingEntry;
                bindingEntry = bindingEntry2;
            }
        }
        this._hashTable = bindingEntryArray;
        this._threshold = (int)((float)n * 0.75f);
    }

    private final class MemoryBindingEnumeration
    implements NamingEnumeration {
        private BindingEntry _entry;
        private int _index;
        private final boolean _nameOnly;
        private final Context _context;
        private final String _contextClassName;
        private Object _nextValue;
        private String _nextName;
        private String _nextClassName;

        MemoryBindingEnumeration(Context context, boolean bl) {
            if (context == null) {
                throw new IllegalArgumentException("Argument context is null");
            }
            this._context = context;
            this._contextClassName = bl ? context.getClass().getName() : null;
            this._nameOnly = bl;
            this._index = MemoryBinding.this._hashTable.length;
        }

        public boolean hasMoreElements() {
            return this.hasMore();
        }

        public Object nextElement() {
            return this.next();
        }

        public void close() {
            this._entry = null;
            this._index = -1;
            this._nextValue = null;
            this._nextName = null;
            this._nextClassName = null;
        }

        public boolean hasMore() {
            if (-1 == this._index) {
                return false;
            }
            if (null != this._nextName) {
                return true;
            }
            return this.internalHasMore();
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasMore()) {
                throw new NoSuchElementException("No more elements in enumeration");
            }
            String string = this._nextName;
            this._nextName = null;
            if (this._nameOnly) {
                return new NameClassPair(string, this._nextClassName, true);
            }
            Object object = this._nextValue;
            this._nextValue = null;
            return new Binding(string, this._nextClassName, object, true);
        }

        private boolean internalHasMore() {
            BindingEntry bindingEntry = this.nextEntry();
            if (null == bindingEntry) {
                return false;
            }
            Object object = bindingEntry._value;
            if (object instanceof MemoryBinding) {
                if (this._nameOnly) {
                    this._nextClassName = this._contextClassName;
                } else {
                    try {
                        this._nextValue = this._context.lookup(bindingEntry._name);
                        this._nextClassName = this._nextValue.getClass().getName();
                    }
                    catch (NamingException namingException) {
                        return this.internalHasMore();
                    }
                }
                this._nextName = bindingEntry._name;
            } else if (object instanceof LinkRef) {
                try {
                    this._nextValue = this._context.lookup(bindingEntry._name);
                    this._nextClassName = null == this._nextValue ? null : this._nextValue.getClass().getName();
                }
                catch (NamingException namingException) {
                    return this.internalHasMore();
                }
                if (this._nameOnly) {
                    this._nextValue = null;
                }
                this._nextName = bindingEntry._name;
            } else if (object instanceof Reference) {
                if (!this._nameOnly) {
                    try {
                        this._nextValue = NamingManager.getObjectInstance(object, new CompositeName(bindingEntry._name), this._context, null);
                    }
                    catch (Exception exception) {
                        return this.internalHasMore();
                    }
                }
                this._nextClassName = ((Reference)object).getClassName();
                this._nextName = bindingEntry._name;
            } else {
                if (!this._nameOnly) {
                    this._nextValue = object;
                }
                this._nextClassName = null == object ? null : object.getClass().getName();
                this._nextName = bindingEntry._name;
            }
            return true;
        }

        private BindingEntry nextEntry() {
            BindingEntry bindingEntry = this._entry;
            if (bindingEntry != null) {
                this._entry = bindingEntry._next;
                return bindingEntry;
            }
            BindingEntry[] bindingEntryArray = MemoryBinding.this._hashTable;
            int n = this._index;
            while (n > 0) {
                if ((bindingEntry = bindingEntryArray[--n]) == null) continue;
                this._entry = bindingEntry._next;
                this._index = n;
                return bindingEntry;
            }
            return null;
        }
    }

    private static class BindingEntry {
        final String _name;
        final int _hashCode;
        Object _value;
        BindingEntry _next;

        BindingEntry(String string, int n, Object object) {
            this._name = string;
            this._hashCode = n;
            this._value = object;
        }
    }
}

