package controllers.services
import scala.collection.mutable.ArrayBuffer
import beans._
import models._
import forms._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._

case class Specification() {

  def loopSpec(data: PartsListBean):Boolean = {
    return loopSpecBody(data.parent, data.child)
  }
  
  def loopSpecBody(parent: String, child: String):Boolean = {
     //子品番の正展開配列
    var partBuffer = ArrayBuffer[PartsListShowBean]()
    for (parentPart <- PartsListDb.parts.where(p => p.name === child )) {
      for(returnPartBuffer <- PartRecursion().down(parentPart, 1, 1, "")) {
        partBuffer += returnPartBuffer
      }
     }
     // 親品番逆展開配列
    var upPartBuffer = ArrayBuffer[PartsListBean]()
    for (childPart <- PartsListDb.parts.where(p => p.name === parent)) {
      for(returnPartBuffer <- PartRecursion().up(childPart, 0)) {
        upPartBuffer += returnPartBuffer
      }
    }
  	// 部品表ループチェック
	// 親品番＝子品番 の場合エラー
	if(child.equals(parent)) {
	  return false
	} else {
	  // 子品番=親品番の逆展開 の場合エラー
	  for(upPart <- upPartBuffer ) {
	    if(upPart.child.equals(child)) {
	      return false
	     }
	   }
	   // 親品番＝子品番の正展開　の場合エラー
	  for(chPart <- partBuffer) {
	    if(chPart.child.equals(parent)) {
	      return false
	    }
	  }
	   // 子品番の正展開=親品番の逆展開 の場合エラー
	  for(chPart <- partBuffer) {
	    for(upPart <- upPartBuffer) {
	      if(upPart.child.equals(chPart.child)) {
	    	 return false
	       }
	     }
	   }
	}
  return true
  }

}