package models.services
import forms._
import beans._
import models._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import scala.collection.mutable.ArrayBuffer

case class DesignChangeManager() {
  def designChange(data: DesignChangeRelationForm) = {
    val dc = PartsListDb.designChanges.where(dc => dc.dcNo === data.dcno).head
    val parent = PartManager().getByName(data.partsListBeanBefore.parent)
    if(!data.partsListBeanBefore.child.isEmpty()) {
      val delRelation = parent.parts.assign(PartManager().getByName(data.partsListBeanBefore.child))
      dc.delPartRelation.assign(delRelation)
      delRelation.dcSeq = dc.dcSeq
      PartsListDb.partRelations.update(delRelation)
    }
    if(!data.partsListBeanAfter.child.isEmpty()) {
      val addRelation = parent.parts.associate(PartManager().getByName(data.partsListBeanAfter.child))
      dc.addPartRelation.associate(addRelation)
      addRelation.quantity = data.partsListBeanAfter.quantity
      addRelation.dcSeq = dc.dcSeq
      PartsListDb.partRelations.update(addRelation)
    }
    dc.dcSeq += 1
    PartsListDb.designChanges.update(dc)
  }
  
  def designChangeList(request: play.api.mvc.Request[play.api.mvc.AnyContent]): String = {
      var designChangeList:String = ""
        inTransaction {
          val designChanges = PartsListDb.designChanges.where(dc => dc.dcNo like request.getQueryString("q").get + "%")
          for(designChange <- designChanges) {
            designChangeList = designChangeList.concat(designChange.dcNo)
            designChangeList = designChangeList.concat("\n")
            }
         }
      return designChangeList
  }
  
  def insert(designChange: DesignChangeForm) = {
    PartsListDb.designChanges.insert(DesignChange(designChange.dcNo, designChange.dcDescription, 1))
  }
  
  def update(id: Long, designChange: DesignChangeForm) = {
    val updDesignChange = getById(id)
    updDesignChange.dcNo = designChange.dcNo
    updDesignChange.dcDescription = designChange.dcDescription
    PartsListDb.designChanges.update(updDesignChange)
  }
  
  def getDesinChangeInformation(designChange: DesignChange): ArrayBuffer[DesignChangeListBean] = {
      var designChangeBuffer = ArrayBuffer[DesignChangeListBean]()
      //変更情報および削除情報をバッファ
      for(delPart <- designChange.delPartRelation) {
        var checkch = 0
        for(addPart <- designChange.addPartRelation) {
          if(delPart.dcSeq == addPart.dcSeq) {
        	  designChangeBuffer += DesignChangeListBean(delPart.dcSeq, delPart.parent.head.name, delPart.child.head.name, addPart.parent.head.name, addPart.child.head.name)
        	  checkch = 1
           }
         }
        if(checkch == 0) {
         designChangeBuffer += DesignChangeListBean(delPart.dcSeq, delPart.parent.head.name, delPart.child.head.name, "", "") 
         }
        }
      //追加情報をバッファ        
      for(addPart <- designChange.addPartRelation) {
         var checka = 0
         for(designChange <- designChangeBuffer) {
      	   if(designChange.dcSeq == addPart.dcSeq) {
      	     checka = 1
       	    }
           }
         if(checka == 0) {
             designChangeBuffer += DesignChangeListBean(addPart.dcSeq, "", "", addPart.parent.head.name, addPart.child.head.name)
          }
      }
      return designChangeBuffer
  }
  
  def designChangeCancel(id: Long) ={
    val cancelDesignChange = getById(id)
    PartsListDb.partRelations.deleteWhere(pr => pr.addDcId === cancelDesignChange.id)
    PartsListDb.partRelations.update(pr =>
      where(pr.delDcId === cancelDesignChange.id)
      set(pr.delDcId := 0L))
  }

  def getById(id: Long): DesignChange = {
    PartsListDb.designChanges.where(dc => dc.id === id).head
  }
  
  def list(key: String): org.squeryl.Query[DesignChange] = {
      PartsListDb.designChanges.where(dc => dc.dcNo like key + "%")
  }
  
  def getTargetRelationByDesignChangeId(id: Long): Iterable[PartRelation] = {
    PartsListDb.designChanges.where(dc => dc.id === id ).head.delPartRelation.++:(PartsListDb.designChanges.where(dc2 => dc2.id === id).head.addPartRelation)
  }

}