/*
 * Decompiled with CFR 0.152.
 */
package tyrex.util;

import tyrex.util.Messages;

public class FastThreadLocal
implements Runnable {
    private final Entry[] _table;
    private final int _staleTimeout = 600000;
    private static final int TABLE_SIZE = 1103;

    public FastThreadLocal() {
        this(1103);
    }

    public FastThreadLocal(int n) {
        this._table = new Entry[n];
        Thread thread = new Thread((Runnable)this, Messages.message("tyrex.util.threadLocalDaemonName"));
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    public Object get() {
        Thread thread = Thread.currentThread();
        int n = (thread.hashCode() & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._table[n];
        while (entry != null && entry.thread != thread) {
            entry = entry.next;
        }
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    public void set(Object object) {
        Thread thread = Thread.currentThread();
        int n = (thread.hashCode() & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._table[n];
        while (entry != null && entry.thread != thread) {
            entry = entry.next;
        }
        if (entry != null) {
            entry.value = object;
            return;
        }
        entry = new Entry(object, thread);
        Entry[] entryArray = this._table;
        synchronized (entryArray) {
            entry.next = this._table[n];
            this._table[n] = entry;
        }
    }

    public Object get(Thread thread) {
        int n = (thread.hashCode() & Integer.MAX_VALUE) % this._table.length;
        Entry entry = this._table[n];
        while (entry != null && entry.thread != thread) {
            entry = entry.next;
        }
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Thread thread) {
        Thread thread2 = thread;
        synchronized (thread2) {
            Entry entry;
            int n = (thread.hashCode() & Integer.MAX_VALUE) % this._table.length;
            Entry[] entryArray = this._table;
            synchronized (entryArray) {
                entry = this._table[n];
                if (entry == null) {
                    return;
                }
                if (entry.thread == thread) {
                    this._table[n] = entry.next;
                    return;
                }
            }
            while (entry.next != null && entry.next.thread != thread) {
                entry = entry.next;
            }
            if (entry.next == null) return;
            entry.next = entry.next.next;
            return;
        }
    }

    public Thread[] listThreads(Object object) {
        Thread[] threadArray = null;
        int n = 0;
        while (n < this._table.length) {
            Entry entry = this._table[n];
            while (entry != null) {
                if (object == null || entry.value == object) {
                    if (threadArray == null) {
                        threadArray = new Thread[]{entry.thread};
                    } else {
                        Thread[] threadArray2 = new Thread[threadArray.length + 1];
                        System.arraycopy(threadArray2, 0, threadArray, 0, threadArray.length);
                        threadArray2[threadArray.length] = entry.thread;
                        threadArray = threadArray2;
                    }
                }
                entry = entry.next;
            }
            ++n;
        }
        return threadArray;
    }

    public void run() {
        block5: while (true) {
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n = 0;
            while (true) {
                Entry entry;
                if (n >= this._table.length) continue block5;
                Entry[] entryArray = this._table;
                synchronized (entryArray) {
                    entry = this._table[n];
                    while (entry != null && !entry.thread.isAlive()) {
                        this._table[n] = entry.next;
                        entry = entry.next;
                    }
                }
                if (entry != null) {
                    while (entry.next != null) {
                        if (!entry.next.thread.isAlive()) {
                            entry.next = entry.next.next;
                            continue;
                        }
                        entry = entry.next;
                    }
                }
                ++n;
            }
            break;
        }
    }

    private static final class Entry {
        final Thread thread;
        Object value;
        Entry next;

        Entry(Object object, Thread thread) {
            this.value = object;
            this.thread = thread;
        }

        Entry(Object object) {
            this.value = object;
            this.thread = null;
        }
    }
}

