/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveReplacer;
import com.typesafe.config.impl.SubstitutionExpression;
import java.util.IdentityHashMap;
import java.util.Map;

final class ResolveSource {
    private final AbstractConfigObject root;
    private final Map<AbstractConfigValue, ResolveReplacer> replacements;

    ResolveSource(AbstractConfigObject abstractConfigObject) {
        this.root = abstractConfigObject;
        this.replacements = new IdentityHashMap<AbstractConfigValue, ResolveReplacer>();
    }

    private static AbstractConfigValue findInObject(AbstractConfigObject abstractConfigObject, ResolveContext resolveContext, SubstitutionExpression substitutionExpression) throws AbstractConfigValue.NotPossibleToResolve {
        return abstractConfigObject.peekPath(substitutionExpression.path(), resolveContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractConfigValue lookupSubst(ResolveContext resolveContext, SubstitutionExpression substitutionExpression, int n) throws AbstractConfigValue.NotPossibleToResolve {
        resolveContext.trace(substitutionExpression);
        try {
            Object object;
            AbstractConfigValue abstractConfigValue = ResolveSource.findInObject(this.root, resolveContext, substitutionExpression);
            if (abstractConfigValue == null) {
                object = substitutionExpression.changePath(substitutionExpression.path().subPath(n));
                resolveContext.untrace();
                resolveContext.trace((SubstitutionExpression)object);
                if (n > 0) {
                    abstractConfigValue = ResolveSource.findInObject(this.root, resolveContext, (SubstitutionExpression)object);
                }
                if (abstractConfigValue == null && resolveContext.options().getUseSystemEnvironment()) {
                    abstractConfigValue = ResolveSource.findInObject(ConfigImpl.envVariablesAsConfigObject(), resolveContext, (SubstitutionExpression)object);
                }
            }
            if (abstractConfigValue != null) {
                abstractConfigValue = resolveContext.resolve(abstractConfigValue);
            }
            object = abstractConfigValue;
            return object;
        }
        finally {
            resolveContext.untrace();
        }
    }

    void replace(AbstractConfigValue abstractConfigValue, ResolveReplacer resolveReplacer) {
        ResolveReplacer resolveReplacer2 = this.replacements.put(abstractConfigValue, resolveReplacer);
        if (resolveReplacer2 != null) {
            throw new ConfigException.BugOrBroken("should not have replaced the same value twice: " + abstractConfigValue);
        }
    }

    void unreplace(AbstractConfigValue abstractConfigValue) {
        ResolveReplacer resolveReplacer = this.replacements.remove(abstractConfigValue);
        if (resolveReplacer == null) {
            throw new ConfigException.BugOrBroken("unreplace() without replace(): " + abstractConfigValue);
        }
    }

    private AbstractConfigValue replacement(ResolveContext resolveContext, AbstractConfigValue abstractConfigValue) throws AbstractConfigValue.NotPossibleToResolve {
        ResolveReplacer resolveReplacer = this.replacements.get(abstractConfigValue);
        if (resolveReplacer == null) {
            return abstractConfigValue;
        }
        return resolveReplacer.replace(resolveContext);
    }

    AbstractConfigValue resolveCheckingReplacement(ResolveContext resolveContext, AbstractConfigValue abstractConfigValue) throws AbstractConfigValue.NotPossibleToResolve {
        AbstractConfigValue abstractConfigValue2 = this.replacement(resolveContext, abstractConfigValue);
        if (abstractConfigValue2 != abstractConfigValue) {
            return resolveContext.resolve(abstractConfigValue2);
        }
        AbstractConfigValue abstractConfigValue3 = abstractConfigValue.resolveSubstitutions(resolveContext);
        return abstractConfigValue3;
    }
}

