/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.Request;
import com.ning.http.client.listenable.AbstractListenableFuture;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.impl.FutureImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyResponseFuture<V>
extends AbstractListenableFuture<V> {
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final AsyncHandler handler;
    private final GrizzlyAsyncHttpProvider provider;
    private final Request request;
    private Connection connection;
    FutureImpl<V> delegate;

    GrizzlyResponseFuture(GrizzlyAsyncHttpProvider provider, Request request, AsyncHandler handler) {
        this.provider = provider;
        this.request = request;
        this.handler = handler;
    }

    @Override
    public void done(Callable callable) {
        this.done.compareAndSet(false, true);
        super.done();
    }

    @Override
    public void abort(Throwable t) {
        this.delegate.failure(t);
        if (this.handler != null) {
            this.handler.onThrowable(t);
        }
        this.closeConnection();
        this.done();
    }

    @Override
    public void content(V v) {
        this.delegate.result(v);
    }

    @Override
    public void touch() {
        this.provider.touchConnection(this.connection, this.request);
    }

    @Override
    public boolean getAndSetWriteHeaders(boolean writeHeaders) {
        return writeHeaders;
    }

    @Override
    public boolean getAndSetWriteBody(boolean writeBody) {
        return writeBody;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.handler.onThrowable(new CancellationException());
        this.done();
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return (V)this.delegate.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.delegate.isCancelled() || !this.delegate.isDone()) {
            return (V)this.delegate.get(timeout, unit);
        }
        return null;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    void setDelegate(FutureImpl<V> delegate) {
        this.delegate = delegate;
    }

    private void closeConnection() {
        if (this.connection != null && !this.connection.isOpen()) {
            this.connection.close().markForRecycle(true);
        }
    }
}

