package models.services
import forms._
import beans._
import models._
import controllers.services._
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import scala.collection.mutable.ArrayBuffer

case class DesignChangeManager() {
  def designChange(data: DesignChangeRelationForm): String = {
    var message: String = null
    val dc = getByName(data.dcno)
    // loopチェック後に処理を行うので、設計変更追加処理を先に行う。
    if(!data.partsListBeanAfter.child.isEmpty()) {
      message = relationAdd(data, dc, dc.dcSeq)
     }
    if(message == null && !data.partsListBeanBefore.child.isEmpty()) {
      relationDel(data.partsListBeanBefore.parent, data.partsListBeanBefore.child, data.partsListBeanBefore.quantity, data.partsListBeanBefore.relationKey, dc, dc.dcSeq)
     }
    dc.dcSeq += 1
    PartsListDb.designChanges.update(dc)
    return message
  }
  
  def designChangeList(request: play.api.mvc.Request[play.api.mvc.AnyContent]): String = {
      var designChangeList:String = ""
        inTransaction {
          val designChanges = PartsListDb.designChanges.where(dc => dc.dcNo like request.getQueryString("q").get + "%")
          for(designChange <- designChanges) {
            designChangeList = designChangeList.concat(designChange.dcNo)
            designChangeList = designChangeList.concat("\n")
            }
         }
      return designChangeList
  }
  
  def insert(designChange: DesignChangeForm) = {
    PartsListDb.designChanges.insert(DesignChange(designChange.dcNo, designChange.dcDescription, 1))
  }
  
  def update(id: Long, designChange: DesignChangeForm) = {
    val updDesignChange = getById(id)
    updDesignChange.dcNo = designChange.dcNo
    updDesignChange.dcDescription = designChange.dcDescription
    PartsListDb.designChanges.update(updDesignChange)
  }
  
  def getDesinChangeInformation(designChange: DesignChange): ArrayBuffer[DesignChangeListBean] = {
      var designChangeBuffer = ArrayBuffer[DesignChangeListBean]()
      //変更情報および削除情報をバッファ
      for(delPart <- designChange.delPartRelation) {
        var checkch = 0
        for(addPart <- designChange.addPartRelation) {
          if(delPart.dcSeq == addPart.dcSeq) {
        	  designChangeBuffer += DesignChangeListBean(delPart.dcSeq, delPart.parent.head.name, delPart.child.head.name, delPart.quantity, delPart.relationKey, delPart.dcSeq, addPart.parent.head.name, addPart.child.head.name, addPart.quantity, addPart.relationKey, addPart.dcSeq)
        	  checkch = 1
           }
         }
        if(checkch == 0) {
         designChangeBuffer += DesignChangeListBean(delPart.dcSeq, delPart.parent.head.name, delPart.child.head.name, delPart.quantity, delPart.relationKey, delPart.dcSeq, "", "", 0, "", 0) 
         }
        }
      //追加情報をバッファ        
      for(addPart <- designChange.addPartRelation) {
         var checka = 0
         for(designChange <- designChangeBuffer) {
      	   if(designChange.dcSeq == addPart.dcSeq) {
      	     checka = 1
       	    }
           }
         if(checka == 0) {
             designChangeBuffer += DesignChangeListBean(addPart.dcSeq, "", "", 0, "", 0, addPart.parent.head.name, addPart.child.head.name, addPart.quantity, addPart.relationKey, addPart.dcSeq)
          }
      }
      return designChangeBuffer
  }
  
  def designChangeCancel(id: Long) = {
    val cancelDesignChange = getById(id)
    for (cancelAddRelation <- cancelDesignChange.addPartRelation) {
      relationAddCancel(cancelAddRelation.parent.head, cancelAddRelation.child.head)
    }
    for (cancelDelRelation <- cancelDesignChange.delPartRelation) {
      relationDelCancel(cancelDelRelation)
    }
  }
  
  def designChangeAddCancelBySeq(designChangeId: Long, dcSeq: Long) = {
    val designChange = getById(designChangeId)
    val cancelAddRelation = designChange.addPartRelation.where(pr => pr.dcSeq === dcSeq).head
    relationAddCancel(cancelAddRelation.parent.head, cancelAddRelation.child.head)
  }

  def designChangeDelCancelBySeq(designChangeId: Long, dcSeq: Long) = {
    val designChange = getById(designChangeId)
    val cancelDelRelation = designChange.delPartRelation.where(pr => pr.dcSeq === dcSeq).head
    relationDelCancel(cancelDelRelation)
  }

  def designChangeUpdate(data: DesignChangeRelationForm, partName: String):String = {
    val dc = getByName(data.dcno)
    var message:String = null
    // 更新時に、子品番の変更が無ければ、単純な員数更新
    if(data.partsListBeanAfter.child == partName) {
      val updateRelation = dc.addPartRelation.where(pr => pr.parentId === PartManager().getByName(data.partsListBeanAfter.parent).head.id and
          pr.childId === PartManager().getByName(data.partsListBeanAfter.child).head.id).head
      updateRelation.quantity = data.partsListBeanAfter.quantity
      updateRelation.relationKey = data.partsListBeanAfter.relationKey
      PartsListDb.partRelations.update(updateRelation)      
    } else {
    // 更新時に、子品番の変更は、設計変更追加をキャンセル
      val parent = PartManager().getByName(data.partsListBeanAfter.parent).head
      var dcSeq: Long = 0L
      // loopチェック後に処理を行うので、設計変更追加処理を先に行う。
      // 更新後品番がブランクでなければ、設計変更の追加処理
      if(!data.partsListBeanAfter.child.isEmpty()) {
        val child = PartManager().getByName(data.partsListBeanAfter.child).head
    	 val updateRelation = dc.delPartRelation.where(pr => pr.parentId === parent.id and
    	  		pr.childId === PartManager().getByName(data.partsListBeanBefore.child).head.id).head
        dcSeq = updateRelation.dcSeq
        message = relationAdd(data, dc, dcSeq)
      }
       // 更新前品番がブランクで無ければ、設計変更の追加をキャンセル
      if(message == null && !partName.isEmpty()) {
        val cancelChild = PartManager().getByName(partName).head
    	 val updateRelation = dc.addPartRelation.where(pr => pr.parentId === parent.id and
    	  		pr.childId === cancelChild.id).head
    	 dcSeq = updateRelation.dcSeq
    	 relationAddCancel(updateRelation.parent.head, updateRelation.child.head)
      }
    }
   return message
  }
  
  def relationDel(parentNo: String, childNo: String, quantity: Long, relationKey: String, dc: DesignChange, dcSeq: Long) = {
      val parent = PartManager().getByName(parentNo).head
      val delRelation = parent.parts.assign(PartManager().getByName(childNo).head)
      PartRelationManager().updatePr(delRelation, quantity, relationKey, dc.dcSeq, dc, null)
  }
  
  def relationAdd(data: DesignChangeRelationForm, dc: DesignChange, dcSeq: Long):String = {
    val partsListBean = PartsListBean(data.partsListBeanAfter.parent, data.partsListBeanAfter.child, data.partsListBeanAfter.quantity, data.partsListBeanAfter.relationKey)
    return PartRelationManager().insert(partsListBean, dc, dcSeq)
  }
  
  def relationAddCancel(parent: Part, child: Part) = {
      parent.parts.dissociate(child)    
  }
  
  def relationDelCancel(cancelDelRelation: PartRelation) = {
      cancelDelRelation.delDcId = 0L
      cancelDelRelation.dcSeq = 0L
      PartsListDb.partRelations.update(cancelDelRelation) 
    
  }

  def getById(id: Long): DesignChange = {
    PartsListDb.designChanges.where(dc => dc.id === id).head
  }
  
  def getByName(dcNo: String): DesignChange = {
    PartsListDb.designChanges.where(dc => dc.dcNo === dcNo).head
  }
  
  def list(key: String): org.squeryl.Query[DesignChange] = {
      PartsListDb.designChanges.where(dc => dc.dcNo like key + "%")
  }
  
  def getTargetRelationByDesignChangeId(id: Long): Iterable[PartRelation] = {
    PartsListDb.designChanges.where(dc => dc.id === id ).head.delPartRelation.++:(PartsListDb.designChanges.where(dc2 => dc2.id === id).head.addPartRelation)
  }

}