package controllers.services
import scala.collection.mutable.HashMap
import scala.collection.immutable.Seq
import beans._
import models._
import models.services._
case class PartsList() {
	def getPartsBuffer(opt:Int, page:Int, key:String, relationKey:String):Seq[PartsListShowBean] = {
		var partsBuffer = Seq[PartsListShowBean]()
		val targetParts = PartManager().getByName(key)
		if(targetParts.size != 0) {
		  for(returnPartBuffer <- PartRecursion().down(PartManager().getByName(key).head, 1, opt, relationKey)) {
		    partsBuffer = partsBuffer.:+(returnPartBuffer)
		  }
		}
		return partsBuffer
	}

	def getMatrixPartsList(partsListBeans: Seq[Seq[PartsListShowBean]], allChildren: Seq[Part]): HashMap[Part, Seq[MultiPartsListBean]] = {
	  var matrixPartsListBeans = HashMap[Part, Seq[MultiPartsListBean]]()
      // 抽出した各モデル毎の部品表配列に対し、部品の有無をチェエク
     for(partsListBean <- partsListBeans) {
         var allChildrenList = Seq[MultiPartsListBean]()
          // 全ての部品一覧作成
         for(child <- allChildren.distinct.sortBy(p => p.name)) {
           allChildrenList = allChildrenList.:+(MultiPartsListBean(child, 1))
          }
          // 比較対象モデルの部品一覧作成
         var targetChildren = Seq[MultiPartsListBean]()
         for(targetChildlist <- partsListBean) {
           targetChildren = targetChildren.:+(MultiPartsListBean(targetChildlist.child, 1))
          }
          // 全ての部品一覧の各部品が、比較対象モデルの部品一覧に存在するかチェック。
         if(partsListBean.size !=0 ) {
        	 for(compare <- allChildrenList) {
	  			if(!targetChildren.contains(compare)) {
               //存在しない場合、表示をOff
             		val position:Int = allChildrenList.indexOf(compare)
             		allChildrenList(position).showOn = 0
	  			}
             }
        	 // 表示制御済みの部品表配列を蓄積
        	 matrixPartsListBeans.put(PartManager().getByName(partsListBean.head.parent).head, allChildrenList)
          // 構成部品なしの場合、全部品を表示Off
         } else {
           for(allChild <- allChildrenList) {
             allChild.showOn = 0
             }
             // 表示制御済みの部品表配列を蓄積
           matrixPartsListBeans.put(null, allChildrenList)
          }
     	}
	   return matrixPartsListBeans
	}

}