/*
 * Decompiled with CFR 0.152.
 */
package tyrex.util;

import java.lang.ref.WeakReference;

public final class BackgroundThread
extends Thread {
    private static final boolean EXIT_ON_INTERRUPT = false;
    private static final String DEFAULT_NAME = "BackgroundThread-";
    private static int _counter;
    private volatile long _wait;
    private volatile boolean _exitOnInterrupt;
    private final WeakReference _runnableReference;

    public BackgroundThread(Runnable runnable, long l) {
        this(runnable, l, BackgroundThread.getDefaultName());
    }

    public BackgroundThread(Runnable runnable, long l, String string) {
        this(runnable, l, null, string);
    }

    public BackgroundThread(Runnable runnable, long l, ThreadGroup threadGroup) {
        this(runnable, l, threadGroup, BackgroundThread.getDefaultName());
    }

    public BackgroundThread(Runnable runnable, long l, ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
        if (null == runnable) {
            throw new IllegalArgumentException("The argument 'runnable' is null.");
        }
        this._runnableReference = new WeakReference<Runnable>(runnable);
        this._exitOnInterrupt = false;
        this.setWait(l);
    }

    private static synchronized String getDefaultName() {
        return DEFAULT_NAME + _counter++;
    }

    public boolean getExitOnInterrupt() {
        return this._exitOnInterrupt;
    }

    public void setExitOnInterrupt(boolean bl) {
        this._exitOnInterrupt = bl;
    }

    public long getWait() {
        return this._wait;
    }

    public void setWait(long l) {
        if (0L >= l) {
            throw new IllegalArgumentException("The argument 'wait' " + l + " is invalid.");
        }
        this._wait = l;
    }

    public void run() {
        do {
            try {
                Thread.sleep(this._wait);
            }
            catch (InterruptedException interruptedException) {
                if (this._exitOnInterrupt) break;
            }
            Runnable runnable = (Runnable)this._runnableReference.get();
            if (null == runnable) break;
            runnable.run();
            runnable = null;
        } while (!this._exitOnInterrupt || !this.isInterrupted());
    }
}

