//////////////////////////////////////////////////////////
//
//	MglImageManager
//		- obt@NX
//
//////////////////////////////////////////////////////////
#include "stdafx.h"
#include "MglImageManager.h"

//	RXgN^
CMglImageManager::CMglImageManager()
{
	//m_bInit = FALSE;
	m_myudg = NULL;
	d3d = NULL;

	//	CMyuStringNameMap̃bZ[W
	m_buffers.SetMessage(
		"CMglImageManager::Add()  \"%s\"̖ÕT[tFX݂͑܂B",
		"CMglImageManager::Get()  \"%s\"̖ÕT[tFX݂͑܂B" );
}

//	fXgN^
CMglImageManager::~CMglImageManager()
{
	Release();
}


//	
void CMglImageManager::Init( CMglGraphicManager *in_myudg )
{
	//	Direct3Dn
	m_myudg = in_myudg;
	d3d = m_myudg->GetD3dDevPtr();

	//initFlg = TRUE;
}

//	J
void CMglImageManager::Release()
{
	DeleteAll();
}

//	SẴT[tFX폜i_łRelease()Ɠj
void CMglImageManager::DeleteAll()
{
	//_MGL_DEBUGLOG( "+ CMglImageManager::DeleteAll()" );
	m_buffers.DeleteAll();
	//_MGL_DEBUGLOG( "- CMglImageManager::DeleteAll()" );
}

//	ǉ
CMglImage* CMglImageManager::Add( const char *szImageFileName, const char *szBufferName,
			    BOOL bRenderTarget, D3DCOLOR colorKey)
{
	CMglImage* pImage = CMglImageManager::Add( szBufferName );
	//pImage->Create( szImageFileName, bRenderTarget, colorKey );
	pImage->Create( (m_strRootDir + szImageFileName).c_str(), bRenderTarget, colorKey );
	return pImage;
}

//	ǉ
CMglImage* CMglImageManager::Add( const char *szBufferName )
{
	_MGL_DEBUGLOG( "+ CMglImageManager::Add( \"%s\" )", szBufferName );
	InitCheck();

	CMglImage surface;
	surface.Init( m_myudg );
	m_buffers.Add( szBufferName, surface );

	_MGL_DEBUGLOG( "- CMglImageManager::Add( \"%s\" )", szBufferName );

	return Get( szBufferName );
}

//	擾
CMglImage* CMglImageManager::Get( const char *szBufferName )
{
	return m_buffers.Get( szBufferName );
}

//	擾
BOOL CMglImageManager::IsExist( const char *szBufferName )
{
	return m_buffers.IsExist( szBufferName );
}

//	폜
void CMglImageManager::Delete( const char *szBufferName )
{
	m_buffers.Delete( szBufferName );
}


void CMglImageManager::SetRootDirectory( const char* szRootDir ){
	m_strRootDir = szRootDir;
	PathLastYenedString(m_strRootDir);
}
