//////////////////////////////////////////////////////////
//
//	MglDirectMusicBase
//		- DirectMusicNX
//
//////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MglDirectMusicBase.h"

/*
#ifdef _DEBUG
	#pragma comment(lib, "Strmbasd.lib")
#else
	#pragma comment(lib, "Strmbase.lib")
#endif//_DEBUG
*/

//template class DLL_EXP std::map<std::string,IDirectMusicSegment8*>;

#define ENBL_CHK()	if(m_flgEnable!=TRUE)return;
	

//	RXgN^
CMglDirectMusicBase::CMglDirectMusicBase()
{
	m_pLoader = NULL;
	m_pPerformance = NULL;
	//m_segments = NULL;
	m_flgEnable = TRUE;
}

//	fXgN^
CMglDirectMusicBase::~CMglDirectMusicBase()
{
	Release();
}

//	
void CMglDirectMusicBase::InitEx( HWND hWnd, const char *szBaseDirectory,
								  DWORD dwDefaultPathType, DWORD dwPerformanceChannelCount, DWORD dwFlags )
{
	//ENBL_CHK(); <-- Rɂ̓_ȂcH(2007/02/18)

	if ( hWnd == NULL )
		hWnd = GetDefaultHwnd();

	/*
	MyuAssert( CoInitialize(NULL), S_OK,
		"CMglDirectMusicBase::Init()  CoInitialize()ɎsB" );
	*/

	MyuAssert( CoCreateInstance(CLSID_DirectMusicLoader, NULL, 
                     CLSCTX_INPROC, IID_IDirectMusicLoader8,
                     (void**)&m_pLoader), S_OK,
		"CMglDirectMusicBase::Init()  CoCreateInstance(IID_IDirectMusicLoader8)ɎsB" );

    MyuAssert( CoCreateInstance(CLSID_DirectMusicPerformance, NULL,
                     CLSCTX_INPROC, IID_IDirectMusicPerformance8,
                     (void**)&m_pPerformance ), S_OK,
		"CMglDirectMusicBase::Init()  CoCreateInstance(IID_IDirectMusicPerformance8)ɎsB" );

	MyuAssert( m_pPerformance->InitAudio( 
			NULL,                  // IDirectMusic C^[tFCX͕svB
			NULL,                  // IDirectSound C^[tFCX͕svB
			hWnd,                  // EBhẼnhB
			dwDefaultPathType,	   // ftHg̃I[fBIpX ^Cv
//			DMUS_APATH_DYNAMIC_STEREO,  // ftHg̃I[fBIpX ^Cv
//			DMUS_APATH_SHARED_STEREOPLUSREVERB,  // ftHg̃I[fBIpX ^Cv
			dwPerformanceChannelCount, // ptH[}X `l̐B
			dwFlags,       // VZTCŰ@\B
			NULL                   // I[fBI p[^ɂ̓ftHggpB
		), S_OK,
		"CMglDirectMusicBase::Init()  m_pPerformance->InitAudio()ɎsB" ); 

 
	// Unicode ɕϊB
	WCHAR wstrSearchPath[MAX_PATH];
	MultiByteToWideChar( CP_ACP, 0, szBaseDirectory, -1, wstrSearchPath, MAX_PATH );
 
	// fBNgݒ肷B
	MyuAssert( m_pLoader->SetSearchDirectory( GUID_DirectMusicAllTypes, wstrSearchPath, FALSE ), S_OK,
		"CMglDirectMusicBase::Init()  m_pLoader->SetSearchDirectory()ɎsB" ); 
}

//	J
void CMglDirectMusicBase::Release()
{
	if ( m_pLoader == NULL )
		return;

	/*for( SEG_ITR it=m_segments.begin(); it != m_segments.end(); it++ )
		StopSegment( it->second );*/
    m_pPerformance->Stop(
        NULL,   // ׂẴZOg~B
        NULL,   // ׂẴZOgԂ~B
        0,      // ɎsB
        0       // tOB
    );

	m_pPerformance->CloseDown();

	/*m_pLoader->Release(); 
    m_pPerformance->Release();*/
	SAFE_RELEASE(m_pLoader); 
    SAFE_RELEASE(m_pPerformance);

	for( SEG_ITR it=m_segments.begin(); it != m_segments.end(); it++ )
		SAFE_RELEASE( it->second );
	m_segments.clear();
 
    //CoUninitialize();

	/*
	//	JKv
	for( SEG_ITR it=m_segments.begin(); it != m_segments.end(); it++ )
		m_pLoader->ReleaseObject( it->second );
	*/
}

//	ǂݍ
void CMglDirectMusicBase::Load( const char* szAudioFile, const char* szAlias )
{
	//ENBL_CHK(); <-- Rɂ̓_ȂcH(2007/02/18)

	InitCheck();

	if ( szAlias == NULL )
		szAlias = szAudioFile;

	//	ɖ`FbN
	if ( IsExist(szAlias) == TRUE )
		MyuThrow( 0, "CMglDirectMusicBase::Load()  \"%s\"̖ÕZOg݂͑܂B", szAlias );

	/* <-- szBaseDirectoryLȂƂȂB߂ǂ̂Ō
	//	t@C݂̑O`FbN
	if ( exist_file( szAudioFile ) == false )
		MyuThrow( hret, "CMglDirectMusicBase::Load()  t@C \"%s\" ܂B", szAudioFile );
	*/

	WCHAR wstrFileName[32000*2+1];
	ZeroMemory( wstrFileName, sizeof(wstrFileName) );

	m_segments[szAlias] = NULL;
	MultiByteToWideChar(CP_ACP, 0, szAudioFile, strlen(szAudioFile), wstrFileName, sizeof(wstrFileName));
	//mbsrtowcs( wstrFileName, &szAlias, MAX_PATH+1, ps != 0 ? ps : &internal );

    /*MyuAssert( m_pLoader->LoadObjectFromFile(
        CLSID_DirectMusicSegment,   // NXʎqB
        IID_IDirectMusicSegment8,   // ړĨC^[tFCX IDB
        wstrFileName,               // t@CB
        (LPVOID*) &m_segments[szAlias]       // C^[tFCX󂯎|C^B
		), S_OK,
		"Audiot@C %s (name:%s)̓ǂݍ݂ɎsB", szAudioFile, szAlias );*/

    HRESULT hret = m_pLoader->LoadObjectFromFile(
        CLSID_DirectMusicSegment,   // NXʎqB
        IID_IDirectMusicSegment8,   // ړĨC^[tFCX IDB
        wstrFileName,               // t@CB
        (LPVOID*) &m_segments[szAlias]       // C^[tFCX󂯎|C^B
		);
	switch( hret )
	{
	case S_OK:
		break;
	case DMUS_E_LOADER_FAILEDOPEN:
		MyuThrow( hret, "CMglDirectMusicBase::Load()  t@C \"%s\" ͌ȂLMediat@Cł͂܂B", szAudioFile );
		//MyuThrow( hret, "CMglDirectMusicBase::Load()  t@C \"%s\" ͗LMediat@Cł͂܂B", szAudioFile );
	case DMUS_E_LOADER_FORMATNOTSUPPORTED:
	case DMUS_E_UNSUPPORTED_STREAM:
		MyuThrow( hret, "CMglDirectMusicBase::Load()  t@C \"%s\" ̓T|[gĂȂAudio`łB", szAudioFile );
	default:
		MyuThrow( hret, "Audiot@C \"%s\" ̓ǂݍ݂ɎsB", szAudioFile );
	}

    MyuAssert( m_segments[szAlias]->Download( m_pPerformance ), S_OK,
		"CMglDirectMusicBase::Load()  m_segments[szAlias]->Download()ɎsB" );
}

//	Đ
inline void CMglDirectMusicBase::PlaySegment( const char* szAliasName )
{
	ENBL_CHK();
	LoopPlaySegment( szAliasName, 0 );
}

//	[vĐ
void CMglDirectMusicBase::LoopPlaySegment( const char* szAliasName, DWORD dwLoopCount )
{
	ENBL_CHK();
	InitCheck();
	ExistChk(szAliasName);

	m_segments[szAliasName]->SetRepeats( dwLoopCount );
	MyuAssert( m_pPerformance->PlaySegmentEx(
        m_segments[szAliasName],  // ĐZOgB
        NULL,        // \OɎgpp[^BĂȂB
        NULL,        // gWVɊւp[^B 
        DMUS_SEGF_SECONDARY,           // tOB
        0,           // Jn^CB0 ͒ɊJnB
        NULL,        // ZOgԂ󂯎|C^B
        NULL,        // ~IuWFNgB
        NULL )       // ftHgłȂꍇ̓I[fBIpXB
		,S_OK, "CMglDirectMusicBase::PlaySegment()  m_pPerformance->PlaySegmentEx()ɎsB" );
}

//	~߂
void CMglDirectMusicBase::Stop( const char* szAliasName )
{
	ENBL_CHK();
	InitCheck();
	ExistChk(szAliasName);
	StopSegment( m_segments[szAliasName] );
}

//	~߂2
void CMglDirectMusicBase::StopSegment( IDirectMusicSegment* pSegment )
{
	ENBL_CHK();
	InitCheck();

	MyuAssert( m_pPerformance->StopEx( pSegment, 0, 0 ),
		S_OK, "CMglDirectMusicBase::StopSegment()  m_pPerformance->StopEx()ɎsB" );
}

//	S~߂
void CMglDirectMusicBase::StopAll()
{
	InitCheck();

	for( SEG_ITR it=m_segments.begin(); it != m_segments.end(); it++ )
		StopSegment( it->second );
}

//	{[̐ݒ
void CMglDirectMusicBase::SetVolume( int nVolume )
{    
	//ENBL_CHK(); <-- Rɂ̓_ȂcH(2007/02/18)
	InitCheck();
	MyuAssert( m_pPerformance->SetGlobalParam( GUID_PerfMasterVolume, (VOID*)&nVolume, sizeof(long) ), S_OK,
		"CMglDirectMusicBase::SetVolume()  m_pPerformance->SetGlobalParam()ɎsB" );
}

//	|C^擾
IDirectMusicSegment8* CMglDirectMusicBase::GetSegmentPtr( const char* szAliasName )
{
	InitCheck();
	ExistChk(szAliasName);
	return m_segments[szAliasName];
}
