#include "stdafx.h"
#include "MglD3dCapsDumper.h"
#include "MglManager.h"


////////////////////////////////////////////////////////////////////////
//
//		Caps̃_v
//
////////////////////////////////////////////////////////////////////////

//void CMglD3dCapsDumper::DumpAdapterInfo( D3DCAPS8* pCapsHal, D3DCAPS8* pCapsRef )
void CMglD3dCapsDumper::DumpAdapterInfo( _IDirect3DX* m_pD3d, _D3DCAPSx* pCaps )
{
	_MGL_DEBUGLOG( "+ CMglD3dCapsDumper::DumpAdapterInfo()" );

	FILE *fp=fopen( CAPS_DUMP_LOG, "w" );
	if ( fp == NULL )
		MyuThrow( 0, "CMglD3dCapsDumper::DumpCapsAll()  Ot@C̃I[vɎsB" );


	fprintf( fp, "==== AdapterInfo =================================\n\n" );
	for( int i=0; i<m_pD3d->GetAdapterCount(); i++ )
	{
		_D3DADAPTER_IDENTIFIERx adapterInfo;
		//m_pD3d->GetAdapterIdentifier( i, 0, &adapterInfo );
#if _MGL_DXVER == 9
		m_pD3d->GetAdapterIdentifier( i, 0, &adapterInfo );
#else
		m_pD3d->GetAdapterIdentifier( i, D3DENUM_NO_WHQL_LEVEL, &adapterInfo );
#endif

		fprintf( fp, "Description :              %s\n", adapterInfo.Description );
		fprintf( fp, "Driver :                   %s\n", adapterInfo.Driver );
		fprintf( fp, "DriverVersion :            %d,%u\n\n", adapterInfo.DriverVersion.HighPart, adapterInfo.DriverVersion.LowPart );
	}

	//fprintf( fp, "\n\n==== HAL =========================================\n\n" );
	fprintf( fp, "\n\n==== Caps =========================================\n\n" );
	DumpCaps( fp, pCaps );

	/*
	fprintf( fp, "\n\n==== REF =========================================\n\n" );
	DumpCaps( fp, pCapsRef );*/
  
	fclose( fp );

	_MGL_DEBUGLOG( "- CMglD3dCapsDumper::DumpAdapterInfo()" );
}

void CMglD3dCapsDumper::DumpCaps( FILE *fp, _D3DCAPSx* caps )
{
	fprintf( fp, "DeviceType :               D3DDEVTYPE_%s\n", GetDeviceTypeString(caps->DeviceType) );
	/*
	switch( caps->DeviceType )
	{
	case D3DDEVTYPE_HAL:
		fprintf( fp, "DeviceType :               D3DDEVTYPE_HAL\n" );
		break;
	case D3DDEVTYPE_REF:
		fprintf( fp, "DeviceType :               D3DDEVTYPE_REF\n" );
		break;
	case D3DDEVTYPE_SW:
		fprintf( fp, "DeviceType :               D3DDEVTYPE_SW\n" );
		break;
	}
	*/
	//fprintf( fp, "DeviceType :               %u\n", caps->DeviceType );
	fprintf( fp, "AdapterOrdinal :           %u\n\n", caps->AdapterOrdinal );

	fprintf( fp, "Caps :                     0x%08x\n", caps->Caps );
	fprintf( fp, "Caps2 :                    0x%08x\n", caps->Caps2 );
	fprintf( fp, "Caps3 :                    0x%08x\n\n", caps->Caps3 );

	////////////////////////////////////////////////////////////////////////////////////

	DumpFlagItem( fp, caps->Caps2, D3DCAPS2_CANMANAGERESOURCE, "Driver Manage Resource" );

	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_CANBLTSYSTONONLOCAL, "CanBLTSYSTONONLOCAL" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_CANRENDERAFTERFLIP, "CanRENDERAFTERFLIP" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_DRAWPRIMTLVERTEX, "DrawPrimitive HAL Export" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_EXECUTESYSTEMMEMORY, "Execute SYSTEM MEMORY" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_EXECUTEVIDEOMEMORY, "EXECUTE VIDEO MEMORY" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_HWRASTERIZATION, "HW RASTERIZATION" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_HWTRANSFORMANDLIGHT, "HW TRANSFORM AND LIGHT" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_NPATCHES, "NPATCHES" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_PUREDEVICE, "PURE DEVICE" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_QUINTICRTPATCHES, "QUINTICRTPATCHES" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_RTPATCHES, "RTPATCHES" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_RTPATCHHANDLEZERO, "RTPATCHHANDLEZERO" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_SEPARATETEXTUREMEMORIES, "SEPARATETEXTUREMEMORIES" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_TEXTURENONLOCALVIDMEM, "TEXTURE NON LOCAL VID MEM" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_TEXTURESYSTEMMEMORY, "TEXTURE SYSTEM MEMORY" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_TEXTUREVIDEOMEMORY, "TEXTURE VIDEO MEMORY" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_TLVERTEXSYSTEMMEMORY, "TL VERTEX SYSTE MMEMORY" );
	DumpFlagItem( fp, caps->DevCaps, D3DDEVCAPS_TLVERTEXVIDEOMEMORY, "TL VERTEX VIDEO MEMORY" );
	fprintf( fp, "\n" );

/*
DevCaps 
foCX̔\͂tOB 
D3DDEVCAPS_CANBLTSYSTONONLOCAL 
foCX́AVXe eNX`񃍁[J rfI eNX`ւ̃ubgT|[gB 
D3DDEVCAPS_CANRENDERAFTERFLIP 
foCX́Ay[W tbv̌ŁA_O R}hL[ɓ邱ƂłB̃tO̓AvP[V̓ς̂ł͂ȂBPɃfoCXrIł邱Ƃ̂łB 
D3DDEVCAPS_DRAWPRIMTLVERTEX 
foCX́ADrawPrimitive Ή̃n[hEFA AuXgNV C (HAL) GNX|[gB 
D3DDEVCAPS_EXECUTESYSTEMMEMORY 
foCX́AVXe ɂsobt@gpłB 
D3DDEVCAPS_EXECUTEVIDEOMEMORY 
foCX́ArfI ɂsobt@gpłB 
D3DDEVCAPS_HWRASTERIZATION 
foCXɂ́AV[̃X^p̃n[hEFA ANZ[VB 
D3DDEVCAPS_HWTRANSFORMANDLIGHT 
foCX́An[hEFAŃgXtH[ & CeBOT|[głB 
D3DDEVCAPS_NPATCHES 
foCX́AN pb`T|[gB 
D3DDEVCAPS_PUREDEVICE 
foCX́An[hEFAŃX^AgXtH[ACeBOAуVF[fBOT|[głB 
D3DDEVCAPS_QUINTICRTPATCHES 
foCX́A5 xWF B XvCT|[gĂB 
D3DDEVCAPS_RTPATCHES 
foCX́A`юOp`pb`T|[gĂB 
D3DDEVCAPS_RTPATCHHANDLEZERO 
̃foCX\͂ݒ肳ĂꍇAn[hEFA A[LeN`ŏLbVKvȂALbVĂȂpb` (nh 0) ́ALbVꂽpb`ƓlAIɕ`悳BD3DDEVCAPS_RTPATCHHANDLEZERO ̐ݒ̓nh 0 ̃pb``ł邱ƂӖ̂ł͂ȂƂɒӂ邱ƁBnh 0 ̃pb`́A̔\͂ݒ肳Ă邩ǂɊ֌WȂAɕ`łB 
D3DDEVCAPS_SEPARATETEXTUREMEMORIES 
foCX́AƗ v[eNX`sĂB 
D3DDEVCAPS_TEXTURENONLOCALVIDMEM 
foCX́A񃍁[J rfI eNX`擾łB 
D3DDEVCAPS_TEXTURESYSTEMMEMORY 
foCX́AVXe eNX`擾łB 
D3DDEVCAPS_TEXTUREVIDEOMEMORY 
foCX́AfoCX eNX`擾łB 
D3DDEVCAPS_TLVERTEXSYSTEMMEMORY 
foCX́AgXtH[ς݃CeBOς݂̒_pɁAVXe ̃obt@gpłB 
D3DDEVCAPS_TLVERTEXVIDEOMEMORY 
foCX́AgXtH[ς݃CeBOς݂̒_pɁArfI ̃obt@gpłB 
*/

	////////////////////////////////////////////////////////////////////////////////////

	fprintf( fp, "PresentationIntervals :    0x%08x\n", caps->PresentationIntervals );
	fprintf( fp, "CursorCaps :               0x%08x\n", caps->CursorCaps );
	fprintf( fp, "DevCaps :                  0x%08x\n\n", caps->DevCaps );

	fprintf( fp, "PrimitiveMiscCaps :        0x%08x\n", caps->PrimitiveMiscCaps );
	fprintf( fp, "RasterCaps :               0x%08x\n\n", caps->RasterCaps );

	fprintf( fp, "ZCmpCaps :                 0x%08x\n", caps->ZCmpCaps );
	fprintf( fp, "SrcBlendCaps :             0x%08x\n", caps->SrcBlendCaps );
	fprintf( fp, "DestBlendCaps :            0x%08x\n", caps->DestBlendCaps );
	fprintf( fp, "AlphaCmpCaps :             0x%08x\n\n", caps->AlphaCmpCaps );

	fprintf( fp, "ShadeCaps :                0x%08x\n", caps->ShadeCaps );
	fprintf( fp, "TextureCaps :              0x%08x\n", caps->TextureCaps );
	fprintf( fp, "TextureFilterCaps :        0x%08x\n", caps->TextureFilterCaps ); // D3DPTFILTERCAPS for IDirect3DTexture8's
	fprintf( fp, "CubeTextureFilterCaps :    0x%08x\n", caps->CubeTextureFilterCaps ); // D3DPTFILTERCAPS for IDirect3DCubeTexture8's
	fprintf( fp, "VolumeTextureFilterCaps :  0x%08x\n", caps->VolumeTextureFilterCaps ); // D3DPTFILTERCAPS for IDirect3DVolumeTexture8's
	fprintf( fp, "TextureAddressCaps :       0x%08x\n", caps->TextureAddressCaps ); // D3DPTADDRESSCAPS for IDirect3DTexture8's
	fprintf( fp, "VolumeTextureAddressCaps : 0x%08x\n\n", caps->VolumeTextureAddressCaps ); // D3DPTADDRESSCAPS for IDirect3DVolumeTexture8's

	fprintf( fp, "LineCaps :                 0x%08x\n", caps->LineCaps ); // D3DLINECAPS
	fprintf( fp, "StencilCaps :              0x%08x\n", caps->StencilCaps );
	fprintf( fp, "FVFCaps :                  0x%08x\n", caps->FVFCaps );
	fprintf( fp, "\n" );

	fprintf( fp, "MaxTextureWidth :          %u\n", caps->MaxTextureWidth );
	fprintf( fp, "MaxTextureHeight :         %u\n", caps->MaxTextureHeight );
	fprintf( fp, "MaxTextureRepeat :         %u\n", caps->MaxTextureRepeat );
	fprintf( fp, "MaxTextureAspectRatio :    %u\n", caps->MaxTextureAspectRatio );
	fprintf( fp, "MaxTextureBlendStages :    %u\n", caps->MaxTextureBlendStages );
	fprintf( fp, "MaxSimultaneousTextures :  %u\n", caps->MaxSimultaneousTextures );
	fprintf( fp, "\n" );

	fprintf( fp, "TextureOpCaps :            0x%08x\n\n", caps->TextureOpCaps );

	fprintf( fp, "VertexProcessingCaps :     0x%08x\n\n", caps->VertexProcessingCaps );
	fprintf( fp, "MaxActiveLights :          %u\n", caps->MaxActiveLights );
	fprintf( fp, "MaxUserClipPlanes :        %u\n", caps->MaxUserClipPlanes );
	fprintf( fp, "MaxVertexBlendMatrices :   %u\n", caps->MaxVertexBlendMatrices );
	fprintf( fp, "MaxVertexBlendMatrixIndex :%u\n", caps->MaxVertexBlendMatrixIndex );
	fprintf( fp, "MaxVertexW :               %f\n", caps->MaxVertexW );
 	fprintf( fp, "\n" );

	fprintf( fp, "MaxPointSize :             %u\n", caps->MaxPointSize );
	fprintf( fp, "MaxPrimitiveCount :        %u\n", caps->MaxPrimitiveCount );
	fprintf( fp, "MaxVertexIndex :           %u\n", caps->MaxVertexIndex );
	fprintf( fp, "MaxStreams :               %u\n", caps->MaxStreams );
	fprintf( fp, "MaxStreamStride :          %u\n\n", caps->MaxStreamStride );

	//fprintf( fp, "VertexShaderVersion :      0x%08x\n", caps->VertexShaderVersion );
	//fprintf( fp, "PixelShaderVersion :       0x%08x\n", caps->PixelShaderVersion );
	fprintf( fp, "VertexShaderVersion(DWORD):0x%08x\n", caps->VertexShaderVersion );
	fprintf( fp, "PixelShaderVersion(DWORD): 0x%08x\n", caps->PixelShaderVersion );
	fprintf( fp, "VertexShaderVersion :      %s\n", GetShaderVersionString(caps->VertexShaderVersion).c_str() );
	fprintf( fp, "PixelShaderVersion :       %s\n", GetShaderVersionString(caps->PixelShaderVersion ).c_str() );
	fprintf( fp, "MaxVertexShaderConst :     %u\n", caps->MaxVertexShaderConst );
#if _MGL_DXVER == 8
	fprintf( fp, "MaxPixelShaderValue :      %f\n\n", caps->MaxPixelShaderValue );
#else //if _MGL_DXVER == 9
	//	DirectX 9
	fprintf( fp, "\n\n==== DirectX 9 =====================================\n\n" );

	fprintf( fp, "PixelShader1xMaxValue :    %f\n\n", caps->PixelShader1xMaxValue );

	fprintf( fp, "DevCaps2 :                 0x%08x\n\n", caps->DevCaps2 );

	fprintf( fp, "MaxNpatchTessellationLevel :       %f\n\n", caps->MaxNpatchTessellationLevel );

	fprintf( fp, "MasterAdapterOrdinal :             %u\n", caps->MasterAdapterOrdinal );
	fprintf( fp, "AdapterOrdinalInGroup :            %u\n", caps->AdapterOrdinalInGroup );
	fprintf( fp, "NumberOfAdaptersInGroup :          %u\n\n", caps->NumberOfAdaptersInGroup );

	fprintf( fp, "DeclTypes :                        0x%08x\n", caps->DeclTypes );
	fprintf( fp, "NumSimultaneousRTs :               %u\n", caps->NumSimultaneousRTs );
	fprintf( fp, "StretchRectFilterCaps :            0x%08x\n\n", caps->StretchRectFilterCaps );

	//	Vertex Shader 2.0
	fprintf( fp, "\n\n==== Vertex Shader 2.0 ===============================\n\n" );
	fprintf( fp, "VS20Caps :                         0x%08x\n", caps->VS20Caps );
	fprintf( fp, "PS20Caps :                         0x%08x\n\n", caps->PS20Caps );

	fprintf( fp, "VertexTextureFilterCaps :          0x%08x\n", caps->VertexTextureFilterCaps );
	fprintf( fp, "MaxVShaderInstructionsExecuted :   %u\n", caps->MaxVShaderInstructionsExecuted );
	fprintf( fp, "MaxPShaderInstructionsExecuted :   %u\n", caps->MaxPShaderInstructionsExecuted );

	//	Vertex Shader 3.0 - (DirectX 9.0 over)
	fprintf( fp, "\n\n==== Vertex Shader 3.0 ===============================\n\n" );
	fprintf( fp, "MaxVertexShader30InstructionSlots :%u\n", caps->MaxVertexShader30InstructionSlots );
	fprintf( fp, "MaxPixelShader30InstructionSlots : %u\n", caps->MaxPixelShader30InstructionSlots );

/*
********** DirectX 9 **************

    float   PixelShader1xMaxValue;      // max value storable in registers of ps.1.x shaders

    // Here are the DX9 specific ones
    DWORD   DevCaps2;

    float   MaxNpatchTessellationLevel;
    DWORD   Reserved5;

    UINT    MasterAdapterOrdinal;       // ordinal of master adaptor for adapter group
    UINT    AdapterOrdinalInGroup;      // ordinal inside the adapter group
    UINT    NumberOfAdaptersInGroup;    // number of adapters in this adapter group (only if master)
    DWORD   DeclTypes;                  // Data types, supported in vertex declarations
    DWORD   NumSimultaneousRTs;         // Will be at least 1
    DWORD   StretchRectFilterCaps;      // Filter caps supported by StretchRect
    D3DVSHADERCAPS2_0 VS20Caps;
    D3DPSHADERCAPS2_0 PS20Caps;
    DWORD   VertexTextureFilterCaps;    // D3DPTFILTERCAPS for IDirect3DTexture9's for texture, used in vertex shaders
    DWORD   MaxVShaderInstructionsExecuted; // maximum number of vertex shader instructions that can be executed
    DWORD   MaxPShaderInstructionsExecuted; // maximum number of pixel shader instructions that can be executed
    DWORD   MaxVertexShader30InstructionSlots; 
    DWORD   MaxPixelShader30InstructionSlots;
} D3DCAPS9;
*/
#endif

/*
    /* Device Info *
x   D3DDEVTYPE  DeviceType;
x   UINT    AdapterOrdinal;

    /* Caps from DX7 Draw *
x   DWORD   Caps;
x   DWORD   Caps2;
x   DWORD   Caps3;
x   DWORD   PresentationIntervals;

    /* Cursor Caps *
x   DWORD   CursorCaps;

    /* 3D Device Caps *
XX  DWORD   DevCaps;

** X Start
DWORD   PrimitiveMiscCaps;
DWORD   RasterCaps;
DWORD   ZCmpCaps;
DWORD   SrcBlendCaps;
DWORD   DestBlendCaps;
DWORD   AlphaCmpCaps;
DWORD   ShadeCaps;
DWORD   TextureCaps;
DWORD   TextureFilterCaps;          // D3DPTFILTERCAPS for IDirect3DTexture8's
DWORD   CubeTextureFilterCaps;      // D3DPTFILTERCAPS for IDirect3DCubeTexture8's
DWORD   VolumeTextureFilterCaps;    // D3DPTFILTERCAPS for IDirect3DVolumeTexture8's
DWORD   TextureAddressCaps;         // D3DPTADDRESSCAPS for IDirect3DTexture8's
DWORD   VolumeTextureAddressCaps;   // D3DPTADDRESSCAPS for IDirect3DVolumeTexture8's

DWORD   LineCaps;                   // D3DLINECAPS
** X End 

xx  DWORD   MaxTextureWidth, MaxTextureHeight;
    DWORD   MaxVolumeExtent;

x   DWORD   MaxTextureRepeat;
x   DWORD   MaxTextureAspectRatio;
    DWORD   MaxAnisotropy;
x   float   MaxVertexW;

    float   GuardBandLeft;
    float   GuardBandTop;
    float   GuardBandRight;
    float   GuardBandBottom;

    float   ExtentsAdjust;
x   DWORD   StencilCaps;

x   DWORD   FVFCaps;
x   DWORD   TextureOpCaps;
x   DWORD   MaxTextureBlendStages;
x   DWORD   MaxSimultaneousTextures;

x   DWORD   VertexProcessingCaps;
x   DWORD   MaxActiveLights;
x   DWORD   MaxUserClipPlanes;
x   DWORD   MaxVertexBlendMatrices;
x   DWORD   MaxVertexBlendMatrixIndex;

x   float   MaxPointSize;

x   DWORD   MaxPrimitiveCount;          // max number of primitives per DrawPrimitive call
x   DWORD   MaxVertexIndex;
x   DWORD   MaxStreams;
x   DWORD   MaxStreamStride;            // max stride for SetStreamSource

x   DWORD   VertexShaderVersion;
x   DWORD   MaxVertexShaderConst;       // number of vertex shader constant registers

x   DWORD   PixelShaderVersion;
x   float   MaxPixelShaderValue;        // max value of pixel shader arithmetic component

*/

}

void CMglD3dCapsDumper::DumpFlagItem( FILE *fp, DWORD dwValue, DWORD dwMask, const char* szName )
{
	if ( dwValue & dwMask )
		fprintf( fp, "%30s :   true\n", szName );
	else
		fprintf( fp, "%30s :   false\n", szName );

}

//	_/sNZVF[_[̃o[W擾 (from DWORD)
std::string CMglD3dCapsDumper::GetShaderVersionString( DWORD dwShaderVersion )
{
	char work[20];
	sprintf(work, "%d.%d",
		D3DSHADER_VERSION_MAJOR(dwShaderVersion),
		D3DSHADER_VERSION_MINOR(dwShaderVersion));
	return work;
}

const char* CMglD3dCapsDumper::GetDeviceTypeString( D3DDEVTYPE deviceType )
{
	switch( deviceType )
	{
	case D3DDEVTYPE_HAL:
		return "HAL";

	case D3DDEVTYPE_REF:
		return "REF";

	case D3DDEVTYPE_SW:
		return "SW";

	default:
		return NULL;
	}
}

void CMglD3dCapsDumper::DumpDepthStencilTest( _IDirect3DX* m_pD3d, UINT nAdapterNo,
	D3DFORMAT displayFormat, D3DDEVTYPE deviceType )
{
	FILE *fp=fopen( CAPS_DUMP_LOG, "a" );
	if ( fp == NULL )
		MyuThrow( 0, "CMglD3dCapsDumper::DumpCapsAll()  Ot@C̃I[vɎsB" );

	///////////////////////////////////////////////////////////////////////////////////////////

	fprintf( fp, "\n\n==== DepthStencilFormatTest ======================\n\n" );

	fprintf( fp, "DeviceType: %s\n\n", GetDeviceTypeString(deviceType) );

	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D16, fp, "D3DFMT_D16" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D24S8, fp, "D3DFMT_D24S8" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D24X8, fp, "D3DFMT_D24X8" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D32, fp, "D3DFMT_D32" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D15S1, fp, "D3DFMT_D15S1" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D24X4S4, fp, "D3DFMT_D24X4S4" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D16_LOCKABLE, fp, "D3DFMT_D16_LOCKABLE" );

	/*
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D32, fp, "D3DFMT_D32" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D24S8, fp, "D3DFMT_D24S8" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D24X8, fp, "D3DFMT_D24X8" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D24X4S4, fp, "D3DFMT_D24X4S4" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D15S1, fp, "D3DFMT_D15S1" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D16, fp, "D3DFMT_D16" );
	DumpDepthStencilTestItem( m_pD3d, nAdapterNo, displayFormat, deviceType, D3DFMT_D16_LOCKABLE, fp, "D3DFMT_D16_LOCKABLE" );
	*/

	/*
	if ( CheckDepthStencilFormat(nAdapterNo, displayFormat, D3DFMT_D32, deviceType ) == TRUE )
		fprintf( fp, "DriverVersion :            %d,%u\n\n", adapterInfo.DriverVersion.HighPart, adapterInfo.DriverVersion.LowPart );
	
	if ( CheckDepthStencilFormat(nAdapterNo, displayFormat, D3DFMT_D24S8, deviceType ) == TRUE ) {
		depthStencilFormat = D3DFMT_D24S8;
		_MGL_DEBUGLOG( "DepthStencilFormatƂD3DFMT_D24S8gp܂B" );
	}
	else if ( CheckDepthStencilFormat(nAdapterNo, displayFormat, D3DFMT_D24X8, deviceType ) == TRUE ) {
		depthStencilFormat = D3DFMT_D24X8;
		_MGL_DEBUGLOG( "DepthStencilFormatƂD3DFMT_D24X8gp܂B" );
	}
	else if ( CheckDepthStencilFormat(nAdapterNo, displayFormat, D3DFMT_D16, deviceType ) == TRUE ) {  
		depthStencilFormat = D3DFMT_D16;
		_MGL_DEBUGLOG( "DepthStencilFormatƂD3DFMT_D16gp܂B" );
	}
	*/

	fclose( fp );
}

void CMglD3dCapsDumper::DumpDepthStencilTestItem( _IDirect3DX* m_pD3d, UINT nAdapterNo,
	D3DFORMAT displayFormat, D3DDEVTYPE deviceType, D3DFORMAT targetFormat, FILE* fp, const char* szFormatName )
{
//	if ( CheckDepthStencilFormat(nAdapterNo, displayFormat, targetFormat, deviceType ) == TRUE )
	if ( m_pD3d->CheckDeviceFormat( nAdapterNo,
		deviceType, displayFormat, D3DUSAGE_DEPTHSTENCIL, D3DRTYPE_SURFACE, targetFormat ) == S_OK )

		fprintf( fp, "%-20s       o Supported\n", szFormatName );
	else
		fprintf( fp, "%-20s       x Unsupported\n", szFormatName );
}

/*
//	DirectDrawgăfBXvCTCY擾
void CMglD3dCapsDumper::GetVramInfo( DWORD *dwpTotal, DWORD *dwpFree )
{
	//fBXvChCo
	IDirectDraw7* pDDraw=NULL;
	MyuAssert( DirectDrawCreateEx(NULL,(void**)(&pDDraw),IID_IDirectDraw7,NULL), DD_OK,
		"CMglD3dCapsDumper::GetVramInfo()  DirectDrawCreateEx()ɎsB" );

	//VRAM
	DDSCAPS2 ddsCaps2; 
	ZeroMemory(&ddsCaps2, sizeof(ddsCaps2)); 
	ddsCaps2.dwCaps=DDSCAPS_VIDEOMEMORY; 

	MyuAssert( pDDraw->GetAvailableVidMem( &ddsCaps2, dwpTotal, dwpFree ), DD_OK,
		"CMglD3dCapsDumper::GetVramInfo()  pDDraw->GetAvailableVidMem()ɎsB" );

	SAFE_RELEASE(pDDraw);
}
*/
