import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import javax.swing.JPanel;

import com.torn.game.Game;
import com.torn.table.Mark;
import com.torn.table.Table;

@SuppressWarnings("serial")
class TablePanel extends JPanel implements MouseListener, MouseMotionListener {
	private final int SIZE = 50;
	private final int OFFSET = 60;
	
	public TablePanel() {
		/* TODO:Xi[o^͂̃NX̐Ӗł͂Ȃ? */
		addMouseListener(this);
		addMouseMotionListener(this);
	}
	
	public void paint(Graphics g) {
		super.paint(g);
		drawTable(g);
		drawMark(g);
	}
	
	private void drawTable(Graphics g) {
		Table table = Game.getInstance().getTable();
		int size = table.size();
		g.setColor(Color.ORANGE);
		g.fillRect(OFFSET, OFFSET, size * SIZE, size * SIZE);
		g.setColor(Color.BLACK);
		for (int posIdx = 1; posIdx < size; posIdx ++) {
			/*  */
			g.drawLine(
					OFFSET + posIdx * SIZE, OFFSET,
					OFFSET + posIdx * SIZE, OFFSET + size * SIZE);
			g.drawLine(	
					OFFSET,               OFFSET + posIdx * SIZE, 
					OFFSET + size * SIZE, OFFSET + posIdx * SIZE);
		}
		/*  */
		g.setColor(Color.PINK);
		g.drawRect(OFFSET, OFFSET, size * SIZE, size * SIZE);
	}
	private void drawMark(Graphics g) {
		Table table = Game.getInstance().getTable();
		int maxPosIdx = table.size();
		g.setColor(Color.BLACK);
		
		for (int x = 0; x < maxPosIdx; x ++) {
			for (int y = 0; y < maxPosIdx; y ++) {
				Mark mark = table.get(x, y);
				if (null == mark) {
					continue;
				}

				int drawSize = SIZE - 20;
				int posX = OFFSET + x * SIZE + 10;
				int posY = OFFSET + y * SIZE + 10;
				
				switch(mark) {
				case MARU:
					g.drawArc(posX, posY, drawSize, drawSize, 0, 360);
					break;
				case BATU:
					/* E */
					g.drawLine(posX, posY, posX + drawSize, posY + drawSize);
					/*  */
					g.drawLine(posX + drawSize, posY, posX, posY + drawSize);
					break;
				default:
					break;
				}
			}
		}
	}
	
	/***********************************************/
	/* Cxg                                                                                   */
	/***********************************************/
	@Override
	public void mouseDragged(MouseEvent arg0) {
	}
	@Override
	public void mouseMoved(MouseEvent arg0) {
		Point p = arg0.getPoint();
		int posIdxX = (p.x - OFFSET) / SIZE;
		int posIdxY = (p.y - OFFSET) / SIZE;
		
		/* ͈͊O */
		int posIdxMax = Game.getInstance().getTable().size();
		if (posIdxX < 0 || posIdxX >= posIdxMax || posIdxY < 0 || posIdxY >= posIdxMax) {
			return;
		}

		int posX = OFFSET + posIdxX * SIZE;
		int posY = OFFSET + posIdxY * SIZE;
		int drawSize = SIZE;

		/* TODO:ŕ`͂悭Ȃ(ʂĂ܂) */
		/* ꏊLA`˗o悤ɂ */
		Graphics g = this.getGraphics();
		g.setColor(Color.RED);
		g.fillRect(posX, posY, drawSize, drawSize);
		this.repaint();
		g.dispose();
	}

	@Override
	public void mouseClicked(MouseEvent arg0) {
		/* X^[g */
		if (Game.getInstance().isFinished()) {
			Game.getInstance().initGame();
			this.repaint();
			return;
		
		/* Q[ */
		} else {
		
			Point p = arg0.getPoint();
			int posIdxX = (p.x - OFFSET) / SIZE;
			int posIdxY = (p.y - OFFSET) / SIZE;
			if (!Game.getInstance().putMark(posIdxX, posIdxY)) {
				System.out.println("ݒus");
				return;
			}
			Game.getInstance().turnEnd();
			this.repaint();
		}
	}

	@Override
	public void mouseEntered(MouseEvent arg0) {
	}

	@Override
	public void mouseExited(MouseEvent arg0) {
	}

	@Override
	public void mousePressed(MouseEvent arg0) {
	}

	@Override
	public void mouseReleased(MouseEvent arg0) {
	}
}