/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "treemanager/MOTreeGetCommandTest.h"
#include "treemanager/IMOTreeManager.h"

#include "syncml/core/Get.h"
#include "syncml/core/Item.h"
#include "syncml/core/Source.h"

#include "commontypes.h"

#include "Logger/Logger.h"

#include "common/Buffer.h"

const char* const c_GetCommandLog = "MOTreeGetCommand";

#define LOG_INFO_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log

namespace NS_DM_Client
{
//------------------------------------------------------------------------------------------------------
MOTreeGetCommandTest::MOTreeGetCommandTest(ProfileComponentsHolder* prholder,
    GetPtr& command, const String& msgID, NS_Common::EventEx* sigEvent,
    StatusCode& result_status, Buffer& result)
    : MOTreeGetCommand(prholder, command, msgID), m_resultStatus(result_status), m_result(result), m_sigEvent(sigEvent),  m_executed(false)
{

}
//------------------------------------------------------------------------------------------------------
MOTreeGetCommandTest::~MOTreeGetCommandTest(void)
{
    m_sigEvent->signal(m_executed ? e_CommandExecuted : e_CommandDestroyed);
}
//------------------------------------------------------------------------------------------------------
bool MOTreeGetCommandTest::Execute()
{
    return MOTreeGetCommand::Execute();
    //m_resultStatus = (MOTreeGetCommand::Execute()) ? e_Ok : e_Failed;
    //return m_resultStatus == e_Ok;
}
//------------------------------------------------------------------------------------------------------
bool MOTreeGetCommandTest::InvokeResult()
{
    bool res = false;
    if (m_resCode == e_Ok)
    {
        Funambol::ArrayList& results = *(m_GetCommand.get()->getItems());
	    for (int i=0; i<results.size(); ++i)
	    {
		    Funambol::Item *pItem = (Funambol::Item*)results.get(i);
		    if (pItem && pItem->getTarget() && pItem->getData())
		    {
                const char* data = pItem->getData()->getData();
                m_result.Allocate(strlen(data));
                memcpy(m_result.GetPointer(), data, strlen(data));
                res = true;
                m_resultStatus = e_Ok;
		    }
	    }
    }
    else if (m_resCode == e_NotFound)
    {
        m_resultStatus = e_NotFound;
    }
    else if (m_resCode == e_OptionalFeatureNotSupported)
    {
        m_resultStatus = e_OptionalFeatureNotSupported;
    }
    else
    {
        m_resultStatus = e_Failed;
    }
    m_executed = true;
    return res;
}

}
