/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <syncml/core/DevInf.h>
#include "serverexchange/IServerExchangeManager.h"
#include "serverexchange/commands/DevDetailCommand.h"
#include "treemanager/IMOTreeManager.h"
#include "treemanager/TreeLocations.h"
#include "Logger/LoggerMacroses.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Communication;

const char* const c_LogName = "DevDetailCommand";

DevDetailCommand::DevDetailCommand(ProfileComponentsHolder &pch) : PCHAware(pch)
{
}


bool DevDetailCommand::Execute()
{
GDLDEBUG("Start Execute");

    String result;

    Funambol::DevInf di;
    Funambol::VerDTD v("1.2");
    di.setVerDTD(&v);


    // perform all Get operations in root mode
    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DI_DEVID, result, NULL))
        di.setDevID(result.c_str());
    else
        di.setDevID("");
    
    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DI_MAN, result, NULL))
        di.setMan(result.c_str());
    else
        di.setMan("");

    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DI_MOD, result, NULL))
        di.setMod(result.c_str());
    else
        di.setMod("");

    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DD_OEM, result, NULL))
        di.setOEM(result.c_str());
    else
        di.setOEM("");
    
    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DI_DMV, result, NULL))
        di.setDmV(result.c_str());
    else
        di.setDmV("");

    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DI_LANG, result, NULL))
        di.setLang(result.c_str());
    else
        di.setLang("");

    
    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DD_FWV, result, NULL))
        di.setFwV(result.c_str());
    else
        di.setFwV("");

    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DD_SWV, result, NULL))
        di.setSwV(result.c_str());
    else
        di.setSwV("");

    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DD_HWV, result, NULL))
        di.setHwV(result.c_str());
    else
        di.setHwV("");


    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DD_DEVTYP, result, NULL))
        di.setDevTyp(result.c_str());
    else
        di.setDevTyp("");

    if (e_Ok == m_pch.GetMOTreeManager()->GetValue(DD_LOBJ, result, NULL))
    {
        if (!result.compare("true"))
            di.setSupportLargeObjs(true);
        else if (!result.compare("false"))
            di.setSupportLargeObjs(false);
        else
            di.setSupportLargeObjs(false);
    }
    else
        di.setSupportLargeObjs(false);

    di.setUTC(false);
    di.setSupportNumberOfChanges(false);

    m_pch.GetServerExchangeManager()->SetDevInfo(di);

GDLDEBUG("End Execute");

    return true;
}
