/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

//#include "communication/AlertMessage.h"
#include "daemon/ProfileComponentsHolder.h"
#include "serverexchange/FWStatusCommand.h"
#include "serverexchange/IServerExchangeManager.h"
#include <Logger/LoggerMacroses.h>

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_SyncMLCommand;


FWStatusCommand::FWStatusCommand(ProfileComponentsHolder *ph, ExecPtr cmd, StatusCode cmdStatus, const char *serverid, const char *cor) :
    MOTreeResponseCommand(ph, cmd, cmdStatus, "", serverid), m_correlator(NULL), m_ExecCommand(cmd), m_code(cmdStatus)
{
    if (cor)
        m_correlator = Funambol::stringdup(cor);
}


FWStatusCommand::~FWStatusCommand()
{
    SAFE_DELETE_ARR(m_correlator);
}


bool FWStatusCommand::Execute()
{
    //AlertMessage *pAlert = new AlertMessage(Message::MC_CLIENT_INITIATED_MGMT);
    //MessagePtr ptrAlert(pAlert);
//  char buffer[16] = {0};
//  Funambol::ArrayList *items = m_ExecCommand->getItems();
//  if (items && items->size())
//  {
//      const char *srcname = ((Funambol::Item*)items->get(0))->getTarget()->getLocURI();
//      //Funambol::Source source(((Funambol::Item*)items->get(0))->getTarget()->getLocURI());
//      //item.setSource(&source);
//      sprintf(buffer, "%d", m_code);
//      m_pProfile->GetServerExchangeManager()->AddMessage(SCommandFactory::CreateAlert(m_code, srcname, buffer));
//  }
//  else
//  {
//      sprintf(buffer, "%d", e_Failed);
//      m_pProfile->GetServerExchangeManager()->AddMessage(SCommandFactory::CreateAlert(m_code, srcname, buffer));
//
//      //LERROR("Malformed Exec command used");
//  }
//  Funambol::ComplexData data(buffer);
//  item.setData(&data);
//
//  return true;
    return true;
}

