/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "daemon/DaemonEngine.h"
#include "common/Buffer.h"
#include "base/util/StringBuffer.h"
#include "daemon/Configuration.h"
#include "daemon/Profile.h"

#include "Logger/LoggerMacroses.h"
#include "Errors.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Daemon;

static const char c_LoggerInstanceName[] = "DaemonEngine";

StatusCode DaemonEngine::execute_RequestGetProfiles(const Buffer& input, StatusCode& response_res, Buffer& output)
{
LINFO("Enter");

    StatusCode res = response_res = e_Failed;
    size_t profiles_count = m_conf.GetProfilesCount();
    if (profiles_count != 0)
    {
        Profile* p;
        String profile_name, profile_description;
        bool profile_enabled;
        size_t pos = 0;
        size_t data_size;
        for(size_t i = 0; i < profiles_count; ++i)
        {
            p = m_conf.GetProfile(i);
            if (!p)
            {
                response_res = e_Failed;
                break;
            }
            // fetching name
            profile_name = p->GetName();
            data_size = profile_name.length();
            output.Allocate(output.Size() + sizeof(size_t) + data_size);
            memcpy((char*)output.GetPointer() + pos, &data_size, sizeof(size_t));
            pos += sizeof(size_t);
            memcpy((char*)output.GetPointer() + pos, profile_name.c_str(), data_size);
            pos += data_size;
            // fetching description
            profile_description = p->GetDescription();
            data_size = profile_description.length();
            output.Allocate(output.Size() + sizeof(size_t) + data_size);
            memcpy((char*)output.GetPointer() + pos, &data_size, sizeof(size_t));
            pos += sizeof(size_t);
            memcpy((char*)output.GetPointer() + pos, profile_description.c_str(), data_size);
            pos += data_size;
            // fetching is enabled
            profile_enabled = p->IsEnabled();
            output.Allocate(output.Size() + sizeof(bool));
            memcpy((char*)output.GetPointer() + pos, &profile_enabled, sizeof(bool));
            pos += sizeof(bool);
            if (i == profiles_count - 1)
            {
                response_res = res = e_Ok;
            }
        }
    }
    return res;
}

StatusCode DaemonEngine::execute_RequestSetProfileState(const Buffer& input, StatusCode& response_res, Buffer& output)
{
LINFO("Enter");

    StatusCode res = e_Failed;
    size_t name_length = 0;
    String profile_name = "";
    bool profile_enabled =false;

    response_res = e_Failed;
    name_length = *((size_t*)input.GetPointer());
    char* name = (char*)malloc(name_length + 1);
    if(name == NULL)
    {
        response_res = e_Failed;
        res = response_res;
        LERROR("malloc name");
        return res;
    }
    memset(name, 0, name_length + 1);
    memcpy(name, (char*)input.GetPointer() + sizeof(name_length), name_length);
    profile_name = name;
    free(name);
    profile_enabled = *((bool*)((char*)input.GetPointer() + sizeof(name_length) + name_length));

    size_t profiles_count = m_conf.GetProfilesCount();
    if (profiles_count != 0)
    {
        Profile* p;
        for(size_t i = 0; i < profiles_count; ++i)
        {
            p = m_conf.GetProfile(i);
            if (!p)
            {
                response_res = e_Failed;
                break;
            }
            if (p->GetName() == profile_name)
            {
                if (p->Enable(profile_enabled))
                {
                    response_res = e_Ok;
                    res = response_res;
                    break;
                }
            }
            if (i == profiles_count - 1)
            {
                response_res = e_NotFound;
                res = response_res;
            }
        }
    }
    else if (profiles_count == 0)
    {
        response_res = e_NotFound;
        res = response_res;
    }
    return res;
}

